/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssuesFactoryFeatures;
import cdc.issues.api.IssuesWriter;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import cdc.util.office.ss.WorkbookKind;
import java.io.File;

public class IssuesFactory {
    private final IssuesFactoryFeatures features;

    public IssuesFactory(IssuesFactoryFeatures features) {
        this.features = features;
    }

    public IssuesFactoryFeatures getFeatures() {
        return this.features;
    }

    public IssuesWriter createIssuesWriter(File file) {
        Checks.isNotNull((Object)file, (String)"file");
        WorkbookKind wbkind = WorkbookKind.from((File)file);
        if (wbkind != null) {
            return this.createIssuesWriter("cdc.issues.core.WorkbookIssuesWriter");
        }
        if (file.getName().toLowerCase().endsWith(".json")) {
            return this.createIssuesWriter("cdc.issues.core.JsonIssuesWriter");
        }
        throw new IllegalArgumentException("Can not create an IssuesWriter for " + file);
    }

    private IssuesWriter createIssuesWriter(String className) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{IssuesFactoryFeatures.class};
        return (IssuesWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{this.getFeatures()});
    }
}

