/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.locations;

import cdc.issues.api.locations.AbstractIssueLocation;
import cdc.util.lang.Checks;

public class TextFileIssueLocation
extends AbstractIssueLocation {
    private final String systemId;
    private final int lineNumber;
    private final int columnNumber;

    private TextFileIssueLocation(String systemId, int lineNumber, int columnNumber) {
        this.systemId = (String)Checks.isNotNull((Object)systemId, (String)"systemId");
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        if (lineNumber < 1 && columnNumber >= 1) {
            throw new IllegalArgumentException("Non compliant numbers");
        }
    }

    @Override
    public String getTargetId() {
        return this.getSystemId();
    }

    @Override
    public String getPath() {
        if (this.lineNumber >= 1) {
            if (this.columnNumber >= 1) {
                return this.lineNumber + ":" + this.columnNumber;
            }
            return Integer.toString(this.lineNumber);
        }
        return "";
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private int lineNumber = 0;
        private int columnNumber = 0;

        private Builder() {
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder lineNumber(int lineNumber) {
            this.lineNumber = Math.max(0, lineNumber);
            return this;
        }

        public Builder columnNumber(int columnNumber) {
            this.columnNumber = Math.max(0, columnNumber);
            return this;
        }

        public TextFileIssueLocation build() {
            return new TextFileIssueLocation(this.systemId, this.lineNumber, this.columnNumber);
        }
    }
}

