/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueSeverity;
import cdc.issues.api.IssuesHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultIssuesHandler
implements IssuesHandler<Issue> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultIssuesHandler.class);
    private final boolean verbose;
    public static final DefaultIssuesHandler VERBOSE = new DefaultIssuesHandler(true);
    public static final DefaultIssuesHandler QUIET = new DefaultIssuesHandler(false);

    public static <I extends Issue> IssuesHandler<I> get(boolean verbose) {
        if (verbose) {
            DefaultIssuesHandler tmp = VERBOSE;
            return tmp;
        }
        DefaultIssuesHandler tmp = QUIET;
        return tmp;
    }

    protected DefaultIssuesHandler(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void issue(Issue issue) {
        if (this.verbose) {
            if (issue.getSeverity() == IssueSeverity.INFO) {
                LOGGER.info((Object)issue);
            } else if (issue.getSeverity() == IssueSeverity.MINOR) {
                LOGGER.warn((Object)issue);
            } else if (issue.getSeverity() == IssueSeverity.CRITICAL) {
                LOGGER.error((Object)issue);
            } else if (issue.getSeverity() == IssueSeverity.BLOCKER) {
                LOGGER.fatal((Object)issue);
            }
        }
    }
}

