/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssueId;
import cdc.issues.api.IssueLocation;
import cdc.issues.api.IssueParams;
import cdc.issues.api.IssueSeverity;
import cdc.issues.api.RuleId;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Issue {
    private final Instant timestamp;
    private final IssueId id;
    private final IssueSeverity severity;
    private final String description;
    private final Throwable cause;

    protected Issue(Instant timestamp, String domain, String name, IssueParams params, List<? extends IssueLocation> locations, IssueSeverity severity, String description, Throwable cause) {
        this.timestamp = timestamp == null ? Instant.now() : timestamp;
        this.id = new IssueId(domain, name, params, locations.toArray(new IssueLocation[locations.size()]));
        this.severity = (IssueSeverity)((Object)Checks.isNotNull((Object)((Object)severity), (String)"severity"));
        this.description = (String)Checks.isNotNull((Object)description, (String)"description");
        this.cause = cause;
    }

    protected Issue(String domain, String name, IssueParams params, List<? extends IssueLocation> locations, IssueSeverity severity, String description, Throwable cause) {
        this(null, domain, name, params, locations, severity, description, cause);
    }

    protected Issue(Instant timestamp, String domain, Enum<?> name, IssueParams params, List<? extends IssueLocation> locations, IssueSeverity severity, String description, Throwable cause) {
        this(timestamp, domain, name.name(), params, locations, severity, description, cause);
    }

    protected Issue(String domain, Enum<?> name, IssueParams params, List<? extends IssueLocation> locations, IssueSeverity severity, String description, Throwable cause) {
        this(null, domain, name, params, locations, severity, description, cause);
    }

    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public IssueId getId() {
        return this.id;
    }

    public RuleId getRuleId() {
        return this.id.getRuleId();
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> typeClass) {
        return this.id.getName(typeClass);
    }

    public IssueParams getParams() {
        return this.id.getParams();
    }

    public final IssueSeverity getSeverity() {
        return this.severity;
    }

    public final String getDescription() {
        return this.description;
    }

    public IssueLocation[] getLocations() {
        return this.id.getLocations();
    }

    public final int getNumberOfLocations() {
        return this.id.getLocations().length;
    }

    public IssueLocation getLocationAt(int index) {
        return this.id.getLocations()[index];
    }

    public <L extends IssueLocation> L getLocationAt(int index, Class<L> cls) {
        return (L)((IssueLocation)cls.cast(this.getLocationAt(index)));
    }

    public Throwable getCause() {
        return this.cause;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.id, this.severity, this.description, this.cause});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)object;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.id, other.id) && this.severity == other.severity && Objects.equals(this.description, other.description) && Objects.equals(this.cause, other.cause);
    }

    public String toString() {
        return this.getTimestamp() + " " + this.getName() + " " + (Object)((Object)this.getSeverity()) + " " + this.getDescription() + (this.getCause() == null ? "" : " " + this.getCause()) + " " + Arrays.toString(this.getLocations());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static abstract class AbstractIssueBuilder<B extends AbstractIssueBuilder<B, I>, I extends Issue>
    extends Builder {
        protected AbstractIssueBuilder() {
        }

        protected abstract B self();

        @Override
        public Builder timestamp(Instant timestamp) {
            super.timestamp(timestamp);
            return this.self();
        }

        public B ruleId(RuleId ruleId) {
            super.ruleId(ruleId);
            return (B)this.self();
        }

        public B domain(String domain) {
            super.domain(domain);
            return (B)this.self();
        }

        public B name(String name) {
            super.name(name);
            return (B)this.self();
        }

        public B name(Enum<?> name) {
            super.name(name);
            return (B)this.self();
        }

        public B params(IssueParams params) {
            super.params(params);
            return (B)this.self();
        }

        public B addLocation(IssueLocation location) {
            super.addLocation(location);
            return (B)this.self();
        }

        public B locations(IssueLocation[] locations) {
            super.locations(locations);
            return (B)this.self();
        }

        public B locations(List<IssueLocation> locations) {
            super.locations(locations);
            return (B)this.self();
        }

        public B severity(IssueSeverity severity) {
            super.severity(severity);
            return (B)this.self();
        }

        public B description(String description) {
            super.description(description);
            return (B)this.self();
        }

        public B cause(Throwable cause) {
            super.cause(cause);
            return (B)this.self();
        }

        public abstract I build();
    }

    public static class Builder {
        protected Instant timestamp = null;
        protected String domain;
        protected String name;
        protected IssueParams params = IssueParams.NO_PARAMS;
        protected IssueSeverity severity;
        protected String description;
        protected final List<IssueLocation> locations = new ArrayList<IssueLocation>();
        protected Throwable cause = null;

        protected Builder() {
        }

        protected Builder self() {
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this.self();
        }

        public Builder ruleId(RuleId ruleId) {
            this.domain = ruleId.getDomain();
            this.name = ruleId.getName();
            return this.self();
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder name(Enum<?> name) {
            this.name = name.name();
            return this.self();
        }

        public Builder params(IssueParams params) {
            this.params = params;
            return this.self();
        }

        public Builder addLocation(IssueLocation location) {
            this.locations.add(location);
            return this.self();
        }

        public Builder locations(IssueLocation[] locations) {
            this.locations.clear();
            Collections.addAll(this.locations, locations);
            return this;
        }

        public Builder locations(List<IssueLocation> locations) {
            this.locations.clear();
            this.locations.addAll(locations);
            return this;
        }

        public Builder severity(IssueSeverity severity) {
            this.severity = severity;
            return this.self();
        }

        public Builder description(String description) {
            this.description = description;
            return this.self();
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this.self();
        }

        public Issue build() {
            return new Issue(this.timestamp, this.domain, this.name, this.params, this.locations, this.severity, this.description, this.cause);
        }
    }
}

