/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueSeverity;
import cdc.issues.api.IssuesHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class IssuesCollector<I extends Issue>
implements IssuesHandler<I> {
    private final List<I> issues = new ArrayList<I>();
    private final IssuesHandler<I> delegate;

    public IssuesCollector(IssuesHandler<I> delegate) {
        this.delegate = delegate;
    }

    public IssuesCollector() {
        this.delegate = null;
    }

    public IssuesHandler<I> getDelegate() {
        return this.delegate;
    }

    public void clear() {
        this.issues.clear();
    }

    public List<I> getIssues() {
        return this.issues;
    }

    public List<I> getIssues(IssueSeverity severity) {
        return this.issues.stream().filter(i -> i.getSeverity() == severity).collect(Collectors.toList());
    }

    @Override
    public void issue(I issue) {
        this.issues.add(issue);
        if (this.delegate != null) {
            this.delegate.issue(issue);
        }
    }
}

