/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.util.files.Files;
import java.io.File;

public enum IssuesFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    JSON,
    XML;


    public boolean isExportFormat() {
        return true;
    }

    public boolean isImportFormat() {
        switch (this) {
            case CSV: 
            case ODS: 
            case XLS: 
            case XLSM: 
            case XLSX: {
                return true;
            }
        }
        return false;
    }

    public static IssuesFormat from(File file) {
        String ext = Files.getExtension((File)file);
        for (IssuesFormat format : IssuesFormat.values()) {
            if (!format.name().equalsIgnoreCase(ext)) continue;
            return format;
        }
        return null;
    }
}

