/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssueSeverity;
import cdc.issues.api.RuleId;
import cdc.issues.api.RuleParams;
import cdc.util.lang.Checks;
import java.util.Objects;

public class Rule {
    private final RuleId id;
    private final IssueSeverity severity;
    private final String description;
    private final RuleParams params;

    private Rule(RuleId id, IssueSeverity severity, String description, RuleParams params) {
        this.id = (RuleId)Checks.isNotNull((Object)id, (String)"id");
        this.severity = (IssueSeverity)((Object)Checks.isNotNull((Object)((Object)severity), (String)"severity"));
        this.description = (String)Checks.isNotNull((Object)description, (String)"description");
        this.params = (RuleParams)Checks.isNotNull((Object)params, (String)"params");
    }

    public RuleId getId() {
        return this.id;
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.id.getName(cls);
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public RuleParams getParams() {
        return this.params;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.severity, this.description, this.params});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)object;
        return Objects.equals(this.id, other.id) && this.severity == other.severity && Objects.equals(this.description, other.description) && Objects.equals(this.params, other.params);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String domain;
        private String name;
        private IssueSeverity severity;
        private String description;
        private RuleParams params = RuleParams.NO_PARAMS;

        protected Builder() {
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder name(Enum<?> name) {
            this.name = name.name();
            return this;
        }

        public Builder severity(IssueSeverity severity) {
            this.severity = severity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder params(RuleParams params) {
            this.params = params;
            return this;
        }

        public Rule build() {
            return new Rule(new RuleId(this.domain, this.name), this.severity, this.description, this.params);
        }
    }
}

