/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Rule;
import cdc.issues.api.RuleId;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RulesCatalog {
    private final Map<RuleId, Rule> rules = new HashMap<RuleId, Rule>();
    private final Map<String, Set<Rule>> domains = new HashMap<String, Set<Rule>>();

    public void register(Rule rule) {
        Checks.isNotNull((Object)rule, (String)"rule");
        Checks.doesNotContainKey(this.rules, (Object)rule.getId(), (String)"rules");
        this.rules.put(rule.getId(), rule);
        Set set = this.domains.computeIfAbsent(rule.getId().getDomain(), k -> new HashSet());
        set.add(rule);
    }

    public Set<String> getDomains() {
        return this.domains.keySet();
    }

    public Set<RuleId> getRuleIds() {
        return this.rules.keySet();
    }

    public Collection<Rule> getRules() {
        return this.rules.values();
    }

    public Set<Rule> getRules(String domain) {
        return this.domains.getOrDefault(domain, Collections.emptySet());
    }

    public Rule getRuleOrNull(RuleId id) {
        return this.rules.get(id);
    }
}

