/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.locations;

import cdc.issues.api.locations.AbstractIssueLocation;
import cdc.util.lang.Checks;

public class DefaultIssueLocation
extends AbstractIssueLocation {
    private final String targetId;
    private final String path;

    public DefaultIssueLocation(String targetId, String path) {
        this.targetId = (String)Checks.isNotNull((Object)targetId, (String)"targetId");
        this.path = path;
    }

    public DefaultIssueLocation(String targetId) {
        this(targetId, null);
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String targetId;
        private String path = null;

        private Builder() {
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public DefaultIssueLocation build() {
            return new DefaultIssueLocation(this.targetId, this.path);
        }
    }
}

