/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.util.lang.Checks;
import java.util.Objects;

public final class Param {
    private static final String NAME = "name";
    private final String name;
    private final String value;

    private Param(Builder builder) {
        this.name = (String)Checks.isNotNull((Object)builder.name, (String)NAME);
        this.value = builder.value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Param)) {
            return false;
        }
        Param other = (Param)object;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "[" + this.name + "=" + this.value + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String value;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = (String)Checks.isNotNull((Object)name, (String)Param.NAME);
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Param build() {
            return new Param(this);
        }
    }
}

