/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.Issue;
import cdc.issues.answers.IssueAnswer;
import cdc.issues.answers.IssuesAndAnswers;
import cdc.util.lang.Checks;
import cdc.util.lang.CollectionUtils;
import cdc.util.lang.IntHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OutSettings {
    public static final OutSettings ALL_DATA_ANSWERS = OutSettings.builder().build();
    public static final OutSettings ALL_DATA_NO_ANSWERS = OutSettings.builder().hint(Hint.NO_ANSWERS).build();
    private final Set<Hint> hints;
    private final List<String> params;
    private final String paramPrefix;
    private final List<String> metas;
    private final String metaPrefix;
    private final Comparator<? super String> metaComparator;
    private final int numberOfLocations;
    private final int numberOfComments;

    protected OutSettings(Builder builder) {
        this.hints = (Set)Checks.isNotNull(builder.hints, (String)"hints");
        this.params = (List)Checks.isNotNull(builder.params, (String)"params");
        this.paramPrefix = builder.paramPrefix;
        this.metas = (List)Checks.isNotNull(builder.metas, (String)"metas");
        this.metaPrefix = builder.metaPrefix;
        this.metaComparator = (Comparator)Checks.isNotNull(builder.metaComparator, (String)"metaComparator");
        this.numberOfLocations = builder.numberOfLocations;
        this.numberOfComments = builder.numberOfComments;
    }

    public Set<Hint> getHints() {
        return this.hints;
    }

    public boolean isEnabled(Hint hint) {
        return this.hints.contains((Object)hint);
    }

    public List<String> getParams() {
        return this.params;
    }

    public String getParamPrefix() {
        return this.paramPrefix;
    }

    public List<String> getMetas() {
        return this.metas;
    }

    public String getMetaPrefix() {
        return this.metaPrefix;
    }

    public Comparator<? super String> getMetaComparator() {
        return this.metaComparator;
    }

    public int getNumberOfLocations() {
        return this.numberOfLocations;
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    public OutSettings replaceAuto(IssuesAndAnswers issuesAndAnswers) {
        Builder builder = OutSettings.builder();
        boolean hasAuto = false;
        for (Hint hint : this.getHints()) {
            if (hint.isAuto()) {
                hasAuto = true;
                continue;
            }
            builder.hint(hint);
        }
        if (hasAuto) {
            HashSet<String> tmpParams = new HashSet<String>();
            HashSet<String> tmpMetas = new HashSet<String>();
            IntHolder tmpNumberOfLocations = new IntHolder();
            IntHolder tmpNumberOfComments = new IntHolder();
            for (Issue issue : issuesAndAnswers.getIssues()) {
                tmpParams.addAll(issue.getParams().getNames());
                tmpMetas.addAll(issue.getMetas().getNames());
                tmpNumberOfLocations.value = Math.max(tmpNumberOfLocations.value, issue.getLocations().length);
                IssueAnswer answer = issuesAndAnswers.getAnswer(issue.getId()).orElse(null);
                if (answer == null) continue;
                tmpNumberOfComments.value = Math.max(tmpNumberOfComments.value, answer.getComments().size());
            }
            builder.metaPrefix(this.getMetaPrefix());
            builder.paramPrefix(this.getParamPrefix());
            if (this.isEnabled(Hint.AUTO_LOCATIONS)) {
                builder.numberOfLocations(tmpNumberOfLocations.value);
            } else {
                builder.numberOfLocations(this.getNumberOfLocations());
            }
            if (this.isEnabled(Hint.AUTO_METAS)) {
                builder.metas(CollectionUtils.toSortedList(tmpMetas));
            } else {
                builder.metas(this.getMetas());
            }
            if (this.isEnabled(Hint.AUTO_PARAMS)) {
                builder.params(CollectionUtils.toSortedList(tmpParams));
            } else {
                builder.params(this.getParams());
            }
            if (this.isEnabled(Hint.AUTO_COMMENTS)) {
                builder.numberOfComments(tmpNumberOfComments.value);
            } else {
                builder.numberOfComments(this.getNumberOfComments());
            }
            return builder.build();
        }
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
        private final List<String> params = new ArrayList<String>();
        private String paramPrefix = "Param.";
        private final List<String> metas = new ArrayList<String>();
        private String metaPrefix = "Meta.";
        private Comparator<? super String> metaComparator = Comparator.naturalOrder();
        private int numberOfLocations = -1;
        private int numberOfComments = -1;

        protected Builder() {
        }

        public Builder hint(Hint hint) {
            this.hints.add(hint);
            return this;
        }

        public Builder param(String param) {
            this.params.add(param);
            return this;
        }

        public Builder params(Collection<String> params) {
            this.params.addAll(params);
            return this;
        }

        public Builder paramPrefix(String paramPrefix) {
            this.paramPrefix = paramPrefix;
            return this;
        }

        public Builder meta(String meta) {
            this.metas.add(meta);
            return this;
        }

        public Builder metas(Collection<String> metas) {
            this.metas.addAll(metas);
            return this;
        }

        public Builder metaPrefix(String metaPrefix) {
            this.metaPrefix = metaPrefix;
            return this;
        }

        public Builder metaComparator(Comparator<? super String> metaComparator) {
            this.metaComparator = metaComparator;
            return this;
        }

        public Builder numberOfLocations(int numberOfLocations) {
            this.numberOfLocations = numberOfLocations;
            return this;
        }

        public Builder numberOfComments(int numberOfComments) {
            this.numberOfComments = numberOfComments;
            return this;
        }

        public OutSettings build() {
            return new OutSettings(this);
        }
    }

    public static enum Hint {
        NO_PROJECT_COL,
        NO_SNAPSHOT_COL,
        NO_DOMAIN_COL,
        NO_METAS_COL,
        AUTO_METAS,
        NO_PARAMS_COL,
        AUTO_PARAMS,
        NO_ANSWERS,
        NO_LOCATIONS_COL,
        AUTO_LOCATIONS,
        NO_COMMENTS_COL,
        AUTO_COMMENTS;


        public boolean isAuto() {
            return this == AUTO_LOCATIONS || this == AUTO_METAS || this == AUTO_PARAMS || this == AUTO_COMMENTS;
        }
    }
}

