/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.DefaultLocation;
import cdc.issues.locations.Location;
import cdc.issues.locations.TextFileLocation;
import cdc.issues.locations.WorkbookLocation;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public final class Locations {
    private static final Map<String, BiFunction<String, String, ? extends Location>> FACTORIES = new HashMap<String, BiFunction<String, String, ? extends Location>>();

    private Locations() {
    }

    public static void register(String tag, BiFunction<String, String, ? extends Location> factory) {
        Checks.doesNotContainKey(FACTORIES, (Object)tag, (String)"tag");
        Checks.isNotNull(factory, (String)"factory");
        FACTORIES.put(tag, factory);
    }

    public static Set<String> getTags() {
        return FACTORIES.keySet();
    }

    public static BiFunction<String, String, ? extends Location> getFactoryOrNull(String tag) {
        return FACTORIES.get(tag);
    }

    public static Location build(String tag, String path, String anchor) {
        BiFunction<String, String, ? extends Location> factory = Locations.getFactoryOrNull(tag);
        if (factory == null) {
            return new DefaultLocation(path, anchor);
        }
        return factory.apply(path, anchor);
    }

    public static Location build(String location) {
        String tag = Location.getTag(location);
        String path = Location.getPath(location);
        String anchor = Location.getAnchor(location);
        return Locations.build(tag, path, anchor);
    }

    static {
        Locations.register("DefaultLocation", DefaultLocation::new);
        Locations.register("TextFileLocation", TextFileLocation::create);
        Locations.register("WorkbookLocation", WorkbookLocation::create);
    }
}

