/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.StructuredDescription;
import cdc.util.lang.UnexpectedValueException;
import cdc.util.strings.StringUtils;

public class RuleDescription
extends StructuredDescription {
    public static final String SECTION_APPLIES_TO = "Applies to";
    public static final String SECTION_REMARKS = "Remarks";
    public static final String SECTION_RELATED_TO = "Related to";
    public static final String SECTION_SOURCES = "Sources";
    public static final String A = "a";
    public static final String AN = "an";
    public static final String ANY = "any";
    public static final String SOME = "some";
    public static final String THE = "the";
    public static final String ALL = "all";

    protected RuleDescription(Builder builder) {
        super(builder);
    }

    private static String toCapital(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return "";
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        if (s.length() == 1) {
            return Character.toString(Character.toUpperCase(s.charAt(0)));
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    private static String toLower(String s) {
        if (StringUtils.isNullOrEmpty((String)s)) {
            return "";
        }
        return s.toLowerCase();
    }

    private static String toCase(String s, boolean capital) {
        return capital ? RuleDescription.toCapital(s) : RuleDescription.toLower(s);
    }

    private static String format(String specifier, Object arg) {
        switch (specifier) {
            case "wrap": {
                return "[" + arg.toString() + "]";
            }
            case "capital": {
                if (arg == null) {
                    return "";
                }
                return RuleDescription.toCapital(arg.toString()) + " ";
            }
            case "lower": {
                if (arg == null) {
                    return "";
                }
                return RuleDescription.toLower(arg.toString()) + " ";
            }
        }
        throw new UnexpectedValueException("Invalid specifier: " + specifier);
    }

    public static String format(String format, Object ... args) {
        return StringUtils.format((String)format, RuleDescription::format, (Object[])args);
    }

    public static String wrap(String item) {
        return "[" + item + "]";
    }

    private static String wrap(String article, String item) {
        return StringUtils.isNullOrEmpty((String)article) ? RuleDescription.wrap(item) : article + " " + RuleDescription.wrap(item);
    }

    public static String wrap(String article, boolean capital, String item) {
        return RuleDescription.wrap(RuleDescription.toCase(article, capital), item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends StructuredDescription.Builder<Builder> {
        protected Builder() {
        }

        public Builder define(String format, Object ... args) {
            return (Builder)this.text(RuleDescription.format(format, args));
        }

        public Builder wrap(String item) {
            return (Builder)this.text(RuleDescription.wrap(item));
        }

        public Builder wrap(String article, boolean capital, String item) {
            return (Builder)this.text(RuleDescription.wrap(article, capital, item));
        }

        public Builder remarks(String ... remarks) {
            this.section(RuleDescription.SECTION_REMARKS);
            return (Builder)this.uItems(remarks);
        }

        public Builder sources(String ... sources) {
            this.section(RuleDescription.SECTION_SOURCES);
            return (Builder)this.uItems(sources);
        }

        public Builder appliesTo(String ... items) {
            this.section(RuleDescription.SECTION_APPLIES_TO);
            return (Builder)this.uItems(items);
        }

        public Builder relatedTo(String ... items) {
            this.section(RuleDescription.SECTION_RELATED_TO);
            return (Builder)this.uItems(items);
        }

        @Override
        public RuleDescription build() {
            return new RuleDescription(this);
        }
    }
}

