/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.util.strings.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StructuredDescription {
    private static final Pattern SECTION_PATTERN = Pattern.compile("(\\R|^)# .+(\\R|$)");
    private static final Pattern TAIL_NL_PATTERN = Pattern.compile("\\R$");
    private static final Pattern ITEM_START_PATTERN = Pattern.compile("(\\R|^) *(- |\\d+\\) )");
    private final String text;

    private static Pattern sectionPattern(String section) {
        return Pattern.compile("(\\R|^)# " + section + "(\\R|$)");
    }

    private static String removeTailNL(String s) {
        return TAIL_NL_PATTERN.matcher(s).replaceFirst("");
    }

    protected StructuredDescription(Builder<?> builder) {
        this.text = builder.text.toString();
    }

    public String getText() {
        return this.text;
    }

    public String getHeader() {
        Matcher first = SECTION_PATTERN.matcher(this.text);
        if (first.find()) {
            return StructuredDescription.removeTailNL(this.text.substring(0, first.start()));
        }
        return this.text;
    }

    public List<String> getSections() {
        return SECTION_PATTERN.matcher(this.text).results().map(MatchResult::group).toList();
    }

    public boolean hasSection(String section) {
        Pattern pattern = StructuredDescription.sectionPattern(section);
        return pattern.matcher(this.text).find();
    }

    public String getSectionContent(String section) {
        Matcher start = StructuredDescription.sectionPattern(section).matcher(this.text);
        if (start.find()) {
            String tail = this.text.substring(start.end());
            Matcher end = SECTION_PATTERN.matcher(tail);
            String content = end.find() ? StructuredDescription.removeTailNL(tail.substring(0, end.start())) : tail;
            return content;
        }
        return "";
    }

    public List<String> getSectionItems(String section) {
        String content = this.getSectionContent(section);
        if (content != null) {
            String[] items;
            ArrayList<String> list = new ArrayList<String>();
            for (String item : items = ITEM_START_PATTERN.split(content)) {
                if (StringUtils.isNullOrEmpty((String)item)) continue;
                list.add(item);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.getText();
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B>> {
        private final StringBuilder text = new StringBuilder();
        public static final String INDENT = "    ";

        protected Builder() {
        }

        protected static String indent(int level) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                builder.append(INDENT);
            }
            return builder.toString();
        }

        protected B self() {
            Builder x = this;
            return (B)x;
        }

        public B text(String text) {
            this.text.append(text);
            return this.self();
        }

        public B header(String text) {
            return this.text(text);
        }

        public B section(String section) {
            if (this.text.length() > 0) {
                this.text.append("\n\n# ").append(section);
            } else {
                this.text.append("# ").append(section);
            }
            return this.self();
        }

        public B uItem(int level, String item) {
            this.text.append("\n");
            if (level > 0) {
                this.text.append(Builder.indent(level));
            }
            this.text.append("- ").append(item);
            return this.self();
        }

        public B uItem(String item) {
            return this.uItem(0, item);
        }

        public B uItems(int level, String ... items) {
            for (String item : items) {
                this.uItem(level, item);
            }
            return this.self();
        }

        public B uItems(String ... items) {
            return this.uItems(0, items);
        }

        public B uItems(int level, Collection<String> items) {
            for (String item : items) {
                this.uItem(level, item);
            }
            return this.self();
        }

        public B uItems(Collection<String> items) {
            return this.uItems(0, items);
        }

        public B oItem(int level, int number, String item) {
            this.text.append("\n");
            if (level > 0) {
                this.text.append(Builder.indent(level));
            }
            this.text.append(Integer.toString(number)).append(") ").append(item);
            return this.self();
        }

        public B oItem(int number, String item) {
            return this.oItem(0, number, item);
        }

        public B oItems(int level, int number, String ... items) {
            for (String item : items) {
                this.oItem(level, number, item);
                ++number;
            }
            return this.self();
        }

        public B oItems(int number, String ... items) {
            return this.oItems(0, number, items);
        }

        public B oItems(int level, int number, Collection<String> items) {
            for (String item : items) {
                this.oItem(level, item);
            }
            return this.self();
        }

        public B oItems(int number, Collection<String> items) {
            return this.oItems(0, number, items);
        }

        public B violation(String explanation) {
            return ((Builder)this.text("\n")).text(explanation);
        }

        public B value(String value) {
            return ((Builder)((Builder)this.text("\n'")).text(value)).text("'");
        }

        public B justification(int number, String justification) {
            return this.oItem(number, justification);
        }

        public B justifications(String ... justifications) {
            return this.oItems(1, justifications);
        }

        public StructuredDescription build() {
            return new StructuredDescription(this);
        }
    }
}

