/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.office.ss.WorkbookKind;
import cdc.util.files.Files;
import cdc.util.lang.UnexpectedValueException;
import java.io.File;

public enum IssuesFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    JSON,
    XML;


    public WorkbookKind getWorkbookKind() {
        switch (this) {
            case CSV: {
                return WorkbookKind.CSV;
            }
            case ODS: {
                return WorkbookKind.ODS;
            }
            case XLS: {
                return WorkbookKind.XLS;
            }
            case XLSX: {
                return WorkbookKind.XLSX;
            }
            case XLSM: {
                return WorkbookKind.XLSM;
            }
        }
        throw new UnexpectedValueException((Enum)this);
    }

    public boolean isExportFormat() {
        return true;
    }

    public boolean isImportFormat() {
        return true;
    }

    public static IssuesFormat from(File file) {
        String ext = Files.getExtension((File)file);
        for (IssuesFormat format : IssuesFormat.values()) {
            if (!format.name().equalsIgnoreCase(ext)) continue;
            return format;
        }
        return null;
    }
}

