/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.DefaultLocation;
import cdc.issues.locations.Locations;
import cdc.util.strings.StringUtils;

public interface Location
extends Comparable<Location> {
    public static final Location UNDEFINED = new DefaultLocation("", null);
    public static final String SEPARATOR = "::";

    default public String getTag() {
        return this.getClass().getSimpleName();
    }

    public String getPath();

    public String getAnchor();

    default public boolean hasAnchor() {
        return !StringUtils.isNullOrEmpty((String)this.getAnchor());
    }

    @Override
    default public int compareTo(Location other) {
        return this.toString().compareTo(other.toString());
    }

    public static String toString(Location location, boolean addTag) {
        String anchor = location.getAnchor();
        StringBuilder builder = new StringBuilder();
        if (addTag) {
            builder.append(location.getTag()).append(SEPARATOR);
        }
        builder.append(location.getPath());
        if (!StringUtils.isNullOrEmpty((String)anchor)) {
            builder.append(SEPARATOR).append(anchor);
        }
        return builder.toString();
    }

    public static String toString(Location location) {
        return Location.toString(location, true);
    }

    public static String getTag(String location) {
        if (location == null) {
            return null;
        }
        int pos = location.indexOf(SEPARATOR);
        if (pos >= 0) {
            return location.substring(0, pos);
        }
        return null;
    }

    public static String getPath(String location) {
        if (location == null) {
            return null;
        }
        int pos1 = location.indexOf(SEPARATOR);
        if (pos1 >= 0) {
            int pos2 = location.indexOf(SEPARATOR, pos1 + 2);
            if (pos2 >= 0) {
                return location.substring(pos1 + SEPARATOR.length(), pos2);
            }
            return location.substring(pos1 + SEPARATOR.length());
        }
        return null;
    }

    public static String getAnchor(String location) {
        if (location == null) {
            return null;
        }
        int pos1 = location.indexOf(SEPARATOR);
        if (pos1 >= 0) {
            int pos2 = location.indexOf(SEPARATOR, pos1 + 2);
            if (pos2 >= 0) {
                return location.substring(pos2 + SEPARATOR.length());
            }
            return null;
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String tag = null;
        private String path;
        private String anchor = null;

        protected Builder() {
        }

        public Builder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder anchor(String anchor) {
            this.anchor = anchor;
            return this;
        }

        public Location build() {
            return Locations.build(this.tag, this.path, this.anchor);
        }
    }
}

