/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.AbstractLocation;
import cdc.util.lang.Checks;

public class WorkbookLocation
extends AbstractLocation {
    private final String systemId;
    private final String sheetName;
    private final int rowNumber;
    private final String rowId;
    private final String columnName;
    public static final String TAG = "WorkbookLocation";
    private static final String OPEN = "[";
    private static final String SEP = ":";
    private static final String CLOSE = "]";

    protected WorkbookLocation(Builder builder) {
        this.systemId = (String)Checks.isNotNull((Object)builder.systemId, (String)"systemId");
        this.sheetName = builder.sheetName;
        this.rowNumber = builder.rowNumber;
        this.rowId = builder.rowId;
        this.columnName = builder.columnName;
        if (builder.rowNumber > 0 && builder.rowId != null) {
            throw new IllegalArgumentException("Row number and id can not be both defined.");
        }
        if ((builder.rowNumber > 0 || builder.rowId != null || builder.columnName != null) && builder.sheetName == null) {
            throw new IllegalArgumentException("Sheet name is missing.");
        }
    }

    public static WorkbookLocation create(String systemId, String anchor) {
        return WorkbookLocation.builder().systemId(systemId).anchor(anchor).build();
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getPath() {
        return this.getSystemId();
    }

    @Override
    public String getAnchor() {
        if (this.hasSheetData()) {
            if (this.hasColumnData()) {
                if (this.hasRowIdData()) {
                    return this.sheetName + OPEN + this.columnName + SEP + this.rowId + CLOSE;
                }
                if (this.hasRowNumberData()) {
                    return this.sheetName + OPEN + this.columnName + SEP + this.rowNumber + CLOSE;
                }
                return this.sheetName + OPEN + this.columnName + CLOSE;
            }
            if (this.hasRowIdData()) {
                return this.sheetName + "[:" + this.rowId + CLOSE;
            }
            if (this.hasRowNumberData()) {
                return this.sheetName + "[:" + this.rowNumber + CLOSE;
            }
            return this.sheetName;
        }
        return "";
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean hasSheetData() {
        return this.sheetName != null;
    }

    public boolean hasRowNumberData() {
        return this.rowNumber > 0;
    }

    public boolean hasRowIdData() {
        return this.rowId != null;
    }

    public boolean hasRowData() {
        return this.hasRowNumberData() || this.hasRowIdData();
    }

    public boolean hasColumnData() {
        return this.columnName != null;
    }

    public boolean isWorkbookLocation() {
        return !this.hasSheetData() && !this.hasRowData() && !this.hasColumnData();
    }

    public boolean isSheetLocation() {
        return this.hasSheetData() && !this.hasRowData() && !this.hasColumnData();
    }

    public boolean isColumnLocation() {
        return !this.hasRowData() && this.hasColumnData();
    }

    public boolean isRowLocation() {
        return this.hasRowData() && !this.hasColumnData();
    }

    public boolean isCellLocation() {
        return this.hasRowData() && this.hasColumnData();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private String sheetName = null;
        private int rowNumber = 0;
        private String rowId = null;
        private String columnName = null;

        protected Builder() {
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder rowNumber(int rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public Builder rowId(String rowId) {
            this.rowId = rowId;
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder anchor(String anchor) {
            if (anchor == null) {
                this.sheetName = anchor;
                this.rowNumber = 0;
                this.rowId = null;
                this.columnName = null;
            } else {
                int posOpen = anchor.indexOf(WorkbookLocation.OPEN);
                if (posOpen >= 0) {
                    this.sheetName = anchor.substring(0, posOpen);
                    int posSep = anchor.indexOf(WorkbookLocation.SEP, posOpen + 1);
                    int posClose = anchor.indexOf(WorkbookLocation.CLOSE, posOpen + 1);
                    if (posSep >= 0) {
                        String r = anchor.substring(posSep + 1, posClose);
                        try {
                            this.rowNumber = Integer.parseInt(r);
                            this.rowId = null;
                        }
                        catch (NumberFormatException e) {
                            this.rowNumber = 0;
                            this.rowId = r;
                        }
                        this.columnName = posSep == posOpen + 1 ? null : anchor.substring(posOpen + 1, posSep);
                    } else {
                        this.rowNumber = 0;
                        this.rowId = null;
                        this.columnName = anchor.substring(posOpen + 1, posClose);
                    }
                } else {
                    this.sheetName = anchor;
                    this.rowNumber = 0;
                    this.rowId = null;
                    this.columnName = null;
                }
            }
            return this;
        }

        public WorkbookLocation build() {
            return new WorkbookLocation(this);
        }
    }
}

