/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.FormalParams;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueSeverityItem;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class Rule {
    private static final String DESCRIPTION = "description";
    private static final String DOMAIN = "domain";
    private static final String NAME = "name";
    private static final String PARAMS = "params";
    private static final String SEVERITIES = "severities";
    private static final String SEVERITY = "severity";
    private final RuleId id;
    private final Set<IssueSeverity> severities;
    private final String description;
    private final FormalParams params;
    public static final Comparator<Rule> ID_COMPARATOR = Comparator.comparing(Rule::getId);

    protected Rule(Builder builder) {
        this.id = new RuleId(builder.domain, builder.name);
        this.severities = Collections.unmodifiableSet((Set)Checks.isNotNullOrEmpty(builder.severities, (String)SEVERITIES));
        this.description = (String)Checks.isNotNull((Object)builder.description, (String)DESCRIPTION);
        this.params = (FormalParams)Checks.isNotNull((Object)builder.params, (String)PARAMS);
    }

    public RuleId getId() {
        return this.id;
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.id.getName(cls);
    }

    public Set<IssueSeverity> getSeverities() {
        return this.severities;
    }

    public String getDescription() {
        return this.description;
    }

    public FormalParams getParams() {
        return this.params;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.severities, this.description, this.params);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)object;
        return Objects.equals(this.id, other.id) && Objects.equals(this.severities, other.severities) && Objects.equals(this.description, other.description) && Objects.equals(this.params, other.params);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String domain;
        private String name;
        private final Set<IssueSeverity> severities = EnumSet.noneOf(IssueSeverity.class);
        private String description = "";
        private FormalParams params = FormalParams.NO_PARAMS;

        protected Builder() {
        }

        public Builder id(RuleId id) {
            this.domain = id.getDomain();
            this.name = id.getName();
            return this;
        }

        public Builder domain(String domain) {
            Checks.isNotNull((Object)domain, (String)Rule.DOMAIN);
            this.domain = domain;
            return this;
        }

        public Builder name(String name) {
            Checks.isNotNull((Object)name, (String)Rule.NAME);
            this.name = name;
            return this;
        }

        public Builder name(Enum<?> name) {
            Checks.isNotNull(name, (String)Rule.NAME);
            this.name = name.name();
            if (this.severities.isEmpty() && name instanceof IssueSeverityItem) {
                this.addSeverity(((IssueSeverityItem)((Object)name)).getSeverity());
            }
            return this;
        }

        public Builder severity(IssueSeverity severity) {
            Checks.isNotNull((Object)((Object)severity), (String)Rule.SEVERITY);
            this.severities.clear();
            this.severities.add(severity);
            return this;
        }

        public Builder severities(Collection<IssueSeverity> severities) {
            Checks.isNotNull(severities, (String)Rule.SEVERITIES);
            this.severities.clear();
            this.severities.addAll(severities);
            return this;
        }

        public Builder severities(IssueSeverity ... severities) {
            Checks.isNotNull((Object)severities, (String)Rule.SEVERITIES);
            this.severities.clear();
            Collections.addAll(this.severities, severities);
            return this;
        }

        public Builder addSeverity(IssueSeverity severity) {
            Checks.isNotNull((Object)((Object)severity), (String)Rule.SEVERITY);
            this.severities.add(severity);
            return this;
        }

        public Builder addSeverities(Collection<IssueSeverity> severities) {
            Checks.isNotNull(severities, (String)Rule.SEVERITIES);
            this.severities.addAll(severities);
            return this;
        }

        public Builder addSeverities(IssueSeverity ... severities) {
            Checks.isNotNull((Object)severities, (String)Rule.SEVERITIES);
            Collections.addAll(this.severities, severities);
            return this;
        }

        public Builder description(String description) {
            Checks.isNotNull((Object)description, (String)Rule.DESCRIPTION);
            this.description = description;
            return this;
        }

        public Builder params(FormalParams params) {
            Checks.isNotNull((Object)params, (String)Rule.PARAMS);
            this.params = params;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }
    }
}

