/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueSeverity;
import cdc.issues.api.IssuesHandler;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class IssuesCollector<I extends Issue>
implements IssuesHandler<I> {
    private final List<I> issues = new ArrayList<I>();
    private final IssuesHandler<? super I> delegate;

    public IssuesCollector(IssuesHandler<? super I> delegate) {
        this.delegate = (IssuesHandler)Checks.isNotNull(delegate, (String)"delegate");
    }

    public IssuesCollector() {
        this(IssuesHandler.VOID);
    }

    public IssuesHandler<? super I> getDelegate() {
        return this.delegate;
    }

    public void clear() {
        this.issues.clear();
    }

    public List<I> getIssues() {
        return this.issues;
    }

    public List<I> getIssues(IssueSeverity severity) {
        return this.issues.stream().filter(i -> i.getSeverity() == severity).collect(Collectors.toList());
    }

    @Override
    public void issue(I issue) {
        this.issues.add(issue);
        this.delegate.issue(issue);
    }

    @Override
    public void issues(Iterable<? extends I> issues) {
        for (Issue issue : issues) {
            this.issues.add(issue);
        }
        this.delegate.issues(issues);
    }
}

