/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.locations;

import cdc.issues.api.locations.AbstractLocation;
import cdc.util.lang.Checks;

public class WorkbookLocation
extends AbstractLocation {
    private final String systemId;
    private final String sheetName;
    private final int rowNumber;
    private final String columnName;

    private WorkbookLocation(String systemId, String sheetName, int rowNumber, String columnName) {
        this.systemId = (String)Checks.isNotNull((Object)systemId, (String)"systemId");
        this.sheetName = sheetName;
        this.rowNumber = rowNumber;
        this.columnName = columnName;
        if (rowNumber <= 0 && columnName != null) {
            throw new IllegalArgumentException("Non compliant column number of column name.");
        }
        if (rowNumber > 0 && sheetName == null) {
            throw new IllegalArgumentException("Sheet name is missing.");
        }
    }

    @Override
    public String getTargetId() {
        return this.getSystemId();
    }

    @Override
    public String getPath() {
        if (this.isCellLocation()) {
            return this.getSheetName() + ":" + this.getRowNumber() + ":" + this.getColumnName();
        }
        return this.getSheetName() == null ? "" : this.getSheetName();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isCellLocation() {
        return this.rowNumber > 0;
    }

    public boolean isSheetLocation() {
        return this.sheetName != null && !this.isCellLocation();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String systemId;
        private String sheetName = null;
        private int rowNumber = 0;
        private String columnName = null;

        private Builder() {
        }

        public Builder systemId(String systemId) {
            this.systemId = systemId;
            return this;
        }

        public Builder sheetName(String sheetName) {
            this.sheetName = sheetName;
            return this;
        }

        public Builder rowNumber(int rowNumber) {
            this.rowNumber = rowNumber;
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public WorkbookLocation build() {
            return new WorkbookLocation(this.systemId, this.sheetName, this.rowNumber, this.columnName);
        }
    }
}

