/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.rules;

import cdc.issues.api.FormalParams;
import cdc.issues.api.Issue;
import cdc.issues.api.IssuesHandler;
import cdc.issues.api.Params;
import cdc.issues.api.locations.Location;
import cdc.issues.api.rules.Rule;
import java.util.Set;

public interface IssuesDetector<T> {
    public Descriptor<T> getDescriptor();

    default public Class<T> getDataClass() {
        return this.getDescriptor().getDataClass();
    }

    public Set<Rule> getEnabledRules();

    public Params getParams();

    public void analyze(T var1, Location var2, IssuesHandler<Issue> var3);

    public static String toString(IssuesDetector<?> detector) {
        StringBuilder builder = new StringBuilder();
        builder.append("IssuesDetector<").append(detector.getDataClass().getSimpleName()).append(">(");
        boolean first = true;
        for (Rule rule : detector.getEnabledRules()) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(rule.getName());
        }
        builder.append(")");
        return builder.toString();
    }

    public static interface Descriptor<T> {
        public Class<T> getDataClass();

        public Set<Rule> getRules();

        public FormalParams getFormalParams();

        public IssuesDetector<T> create(Params var1, Set<Rule> var2);
    }
}

