/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api.rules;

import cdc.issues.api.Issue;
import cdc.issues.api.IssuesHandler;
import cdc.issues.api.Params;
import cdc.issues.api.locations.LocatedData;
import cdc.issues.api.rules.IssuesDetector;
import cdc.issues.api.rules.Rule;
import cdc.issues.api.rules.RuleId;
import cdc.util.events.ProgressController;
import cdc.util.events.ProgressSupplier;
import cdc.util.lang.Checks;
import cdc.util.lang.Introspection;
import cdc.util.lang.NotFoundException;
import cdc.util.tuples.Tuple2;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

public class RulesCatalog {
    private final Map<RuleId, Rule> ruleIdToRule = new HashMap<RuleId, Rule>();
    private final Map<String, Set<Rule>> domainToRules = new HashMap<String, Set<Rule>>();
    private final Set<IssuesDetector.Descriptor<?>> descriptors = new HashSet();
    private final Map<Tuple2<RuleId, Class<?>>, IssuesDetector.Descriptor<?>> ruleIdDataClassToDescriptor = new HashMap();
    private final Map<Class<?>, Set<IssuesDetector.Descriptor<?>>> dataClassToDescriptors = new HashMap();

    public void register(Rule rule) {
        Checks.isNotNull((Object)rule, (String)"rule");
        Checks.doesNotContainKey(this.ruleIdToRule, (Object)rule.getId(), (String)"rules");
        this.ruleIdToRule.put(rule.getId(), rule);
        Set set = this.domainToRules.computeIfAbsent(rule.getId().getDomain(), k -> new HashSet());
        set.add(rule);
    }

    public <T> void register(IssuesDetector.Descriptor<T> descriptor) {
        Checks.isNotNull(descriptor, (String)"descriptor");
        Checks.doesNotContain(this.descriptors, descriptor, (String)"descriptors");
        this.descriptors.add(descriptor);
        Set set = this.dataClassToDescriptors.computeIfAbsent(descriptor.getDataClass(), k -> new HashSet());
        set.add(descriptor);
        for (Rule rule : descriptor.getRules()) {
            Tuple2 key = new Tuple2((Object)rule.getId(), descriptor.getDataClass());
            if (!this.isRegistered(rule)) {
                this.register(rule);
            }
            if (this.ruleIdDataClassToDescriptor.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate descriptor for " + key);
            }
            this.ruleIdDataClassToDescriptor.put(key, descriptor);
        }
    }

    public Set<String> getDomains() {
        return this.domainToRules.keySet();
    }

    public boolean isRegistered(Rule rule) {
        return this.ruleIdToRule.containsKey(rule.getId());
    }

    public Set<RuleId> getRuleIds() {
        return this.ruleIdToRule.keySet();
    }

    public Collection<Rule> getRules() {
        return this.ruleIdToRule.values();
    }

    public Set<Rule> getRules(String domain) {
        return this.domainToRules.getOrDefault(domain, Collections.emptySet());
    }

    public Rule getRuleOrNull(RuleId id) {
        return this.ruleIdToRule.get(id);
    }

    public Set<IssuesDetector.Descriptor<?>> getDescriptpors() {
        return this.descriptors;
    }

    public <T> Set<IssuesDetector.Descriptor<T>> getDescriptors(Class<T> dataClass) {
        Set set = this.dataClassToDescriptors.getOrDefault(dataClass, Collections.emptySet());
        return (Set)Introspection.uncheckedCast(set);
    }

    public boolean hasDescriptor(Rule rule, Class<?> dataClass) {
        Tuple2 key = new Tuple2((Object)rule.getId(), dataClass);
        return this.ruleIdDataClassToDescriptor.containsKey(key);
    }

    public <T> IssuesDetector.Descriptor<T> getDescriptorOrNull(Rule rule, Class<T> dataClass) {
        Tuple2 key = new Tuple2((Object)rule.getId(), dataClass);
        IssuesDetector.Descriptor descriptor = (IssuesDetector.Descriptor)Introspection.uncheckedCast(this.ruleIdDataClassToDescriptor.get(key));
        return descriptor;
    }

    public <T> IssuesDetector.Descriptor<T> getDescriptor(Rule rule, Class<T> dataClass) {
        IssuesDetector.Descriptor<T> descriptor = this.getDescriptorOrNull(rule, dataClass);
        if (descriptor == null) {
            throw new NotFoundException("No descriptor found for " + rule.getName() + " " + dataClass);
        }
        return descriptor;
    }

    public <T> IssuesDetector<T> createIssuesDetector(Rule rule, Class<T> dataClass, Params params) {
        IssuesDetector.Descriptor<T> descriptor = this.getDescriptor(rule, dataClass);
        HashSet<Rule> rules = new HashSet<Rule>();
        rules.add(rule);
        return descriptor.create(params, rules);
    }

    public <T> void apply(Rule rule, Class<T> dataClass, Params params, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        IssuesDetector<T> detector = this.createIssuesDetector(rule, dataClass, params);
        RulesCatalog.apply(detector, spliterator, issuesHandler, controller);
    }

    public <T> void apply(Class<T> dataClass, Params params, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        for (IssuesDetector.Descriptor<T> descriptor : this.getDescriptors(dataClass)) {
            IssuesDetector<T> detector = descriptor.create(params, descriptor.getRules());
            RulesCatalog.apply(detector, spliterator, issuesHandler, controller);
        }
    }

    public static <T> void apply(IssuesDetector<T> detector, Spliterator<LocatedData<T>> spliterator, IssuesHandler<Issue> issuesHandler, ProgressController controller) {
        Checks.isNotNull(detector, (String)"detector");
        Checks.isNotNull(spliterator, (String)"spliterator");
        Checks.isNotNull(issuesHandler, (String)"issuesHandler");
        Checks.isNotNull((Object)controller, (String)"controller");
        ProgressSupplier progress = new ProgressSupplier(controller);
        progress.reset(spliterator.estimateSize(), IssuesDetector.toString(detector));
        Consumer<LocatedData> consumer = ld -> detector.analyze(ld.getData(), ld.getLocation(), issuesHandler);
        boolean next = true;
        while (next) {
            next = next && spliterator.tryAdvance(consumer);
            next = next && !controller.isCancelled();
            progress.incrementValue();
        }
    }
}

