/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.util.lang.Checks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Diagnosis<I extends Issue> {
    private final List<I> issues;
    public static final Diagnosis<?> OK_DIAGNOSIS = new Diagnosis(new Issue[0]);

    @SafeVarargs
    protected Diagnosis(I ... issues) {
        this((Collection<Issue>)Arrays.asList((Issue[])Checks.isNotNull(issues, (String)"issues")));
    }

    private Diagnosis(Collection<I> issues) {
        Checks.isNotNull(issues, (String)"issues");
        if (issues.isEmpty()) {
            this.issues = Collections.emptyList();
        } else {
            ArrayList<Issue> tmp = new ArrayList<Issue>();
            for (Issue issue : issues) {
                tmp.add(issue);
            }
            this.issues = Collections.unmodifiableList(tmp);
        }
    }

    public static <I extends Issue> Diagnosis<I> okDiagnosis() {
        Diagnosis<?> tmp = OK_DIAGNOSIS;
        return tmp;
    }

    @Deprecated(since="2025-01-02", forRemoval=true)
    public static <I extends Issue> Diagnosis<I> create(Collection<I> issues) {
        return Diagnosis.of(issues);
    }

    @Deprecated(since="2025-01-02", forRemoval=true)
    @SafeVarargs
    public static <I extends Issue> Diagnosis<I> create(I ... issues) {
        return Diagnosis.of(issues);
    }

    public static <I extends Issue> Diagnosis<I> of(Collection<I> issues) {
        if (issues.isEmpty()) {
            return Diagnosis.okDiagnosis();
        }
        return new Diagnosis<I>(issues);
    }

    @SafeVarargs
    public static <I extends Issue> Diagnosis<I> of(I ... issues) {
        return Diagnosis.of(Arrays.asList(issues));
    }

    public List<I> getIssues() {
        return this.issues;
    }

    public boolean isOk() {
        return this.issues.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isOk()) {
            builder.append("OK");
        } else {
            builder.append("KO ");
            for (Issue issue : this.issues) {
                builder.append(issue);
            }
        }
        return builder.toString();
    }
}

