/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.IssueSeverity;
import cdc.issues.Params;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleConfig;
import cdc.util.lang.Checks;
import java.util.Objects;
import java.util.Optional;

public final class ConfiguredRule {
    private final Rule rule;
    private final RuleConfig config;

    private ConfiguredRule(Builder builder) {
        this.rule = builder.rule;
        this.config = builder.config.build();
    }

    public Rule getRule() {
        return this.rule;
    }

    public RuleConfig getConfig() {
        return this.config;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public Optional<IssueSeverity> getCustomizedSeverity() {
        return this.config.getCustomizedSeverity();
    }

    public IssueSeverity getEffectiveSeverity() {
        return this.getCustomizedSeverity().orElse(this.rule.getSeverity());
    }

    public Params getParams() {
        return this.config.getParams();
    }

    public int hashCode() {
        return Objects.hash(this.rule, this.config);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfiguredRule)) {
            return false;
        }
        ConfiguredRule other = (ConfiguredRule)object;
        return Objects.equals(this.rule, other.rule) && Objects.equals(this.config, other.config);
    }

    public String toString() {
        return "[" + this.getRule().getName() + ", " + this.getConfig() + "]";
    }

    public static Builder builder(Rule rule) {
        return new Builder(rule);
    }

    public static class Builder {
        private final Rule rule;
        private final RuleConfig.Builder config = RuleConfig.builder();

        Builder(Rule rule) {
            this.rule = (Rule)Checks.isNotNull((Object)rule, (String)"rule");
        }

        public Builder config(RuleConfig config) {
            this.config.set(config);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.config.enabled(enabled);
            return this;
        }

        public Builder customizedSeverity(IssueSeverity customizedSeverity) {
            this.config.customizedSeverity(customizedSeverity);
            return this;
        }

        public Builder params(Params params) {
            this.config.params(params);
            return this;
        }

        public ConfiguredRule build() {
            return new ConfiguredRule(this);
        }
    }
}

