/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.IssueSeverity;
import cdc.issues.Params;
import cdc.util.lang.Checks;
import java.util.Objects;
import java.util.Optional;

public final class RuleConfig {
    public static final RuleConfig DEFAULT = RuleConfig.builder().build();
    private final boolean enabled;
    private final Optional<IssueSeverity> cvstomizedSeverity;
    private final Params params;

    private RuleConfig(Builder builder) {
        this.enabled = builder.enabled;
        this.cvstomizedSeverity = Optional.ofNullable(builder.customizedSeverity);
        this.params = (Params)Checks.isNotNull((Object)builder.params, (String)"params");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<IssueSeverity> getCustomizedSeverity() {
        return this.cvstomizedSeverity;
    }

    public Params getParams() {
        return this.params;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.cvstomizedSeverity, this.params);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RuleConfig)) {
            return false;
        }
        RuleConfig other = (RuleConfig)object;
        return this.enabled == other.enabled && Objects.equals(this.cvstomizedSeverity, other.cvstomizedSeverity) && Objects.equals(this.params, other.params);
    }

    public String toString() {
        return "[" + this.isEnabled() + ", " + this.getCustomizedSeverity() + ", " + this.getParams() + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = true;
        private IssueSeverity customizedSeverity;
        private Params params = Params.NO_PARAMS;

        Builder() {
        }

        public Builder set(RuleConfig other) {
            this.enabled = other.enabled;
            this.customizedSeverity = other.cvstomizedSeverity.orElse(null);
            this.params = other.params;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder customizedSeverity(IssueSeverity customizedSeverity) {
            this.customizedSeverity = customizedSeverity;
            return this;
        }

        public Builder params(Params params) {
            this.params = params;
            return this;
        }

        public RuleConfig build() {
            return new RuleConfig(this);
        }
    }
}

