/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.LabelsImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface Labels {
    public static final Labels NO_LABELS = Labels.of(new String[0]);

    public Set<String> get();

    default public List<String> getSorted() {
        return this.get().stream().sorted().toList();
    }

    default public boolean isEmpty() {
        return this.get().isEmpty();
    }

    default public Labels add(String label) {
        HashSet<String> set = new HashSet<String>(this.get());
        set.add(label);
        return Labels.of(set);
    }

    default public Labels remove(String label) {
        HashSet<String> set = new HashSet<String>(this.get());
        set.remove(label);
        return Labels.of(set);
    }

    public static boolean isValidLabel(String label) {
        return label != null && LabelsImpl.VALID_LABEL_PATTERN.matcher(label).matches();
    }

    public static Labels of(Collection<String> labels) {
        return new LabelsImpl(Set.copyOf(labels));
    }

    public static Labels of(String ... labels) {
        return new LabelsImpl(Set.of(labels));
    }
}

