/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.answers.IssuesAndAnswers;
import cdc.issues.io.IssuesIoFactory;
import cdc.issues.io.IssuesIoFactoryFeatures;
import cdc.util.events.ProgressController;
import cdc.util.lang.Checks;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;

@FunctionalInterface
public interface IssuesReader {
    public static final Settings ANSWERS = Settings.builder().build();
    public static final Settings NO_ANSWERS = Settings.builder().hint(Settings.Hint.NO_ANSWERS).build();

    public IssuesAndAnswers load(Settings var1, ProgressController var2) throws IOException;

    public static IssuesAndAnswers load(File file, Settings settings, ProgressController controller, IssuesIoFactoryFeatures features) throws IOException {
        IssuesIoFactory factory = new IssuesIoFactory(features);
        IssuesReader reader = factory.createIssuesReader(file);
        return reader.load(settings, controller);
    }

    public static class Settings {
        private final Set<Hint> hints;

        protected Settings(Set<Hint> hints) {
            this.hints = (Set)Checks.isNotNull(hints, (String)"hints");
        }

        public Set<Hint> getHints() {
            return this.hints;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private final Set<Hint> hints = EnumSet.noneOf(Hint.class);

            protected Builder() {
            }

            public Builder hint(Hint hint) {
                this.hints.add(hint);
                return this;
            }

            public Settings build() {
                return new Settings(this.hints);
            }
        }

        public static enum Hint {
            NO_ANSWERS;

        }
    }
}

