/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.locations;

import cdc.issues.locations.LocatedItem;
import cdc.issues.locations.Location;
import cdc.util.lang.Checks;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LocatedObject<O>
implements LocatedItem {
    private final O object;
    private final Location location;

    private LocatedObject(O object, Location location) {
        Checks.isNotNull((Object)location, (String)"location");
        this.object = object;
        this.location = location;
    }

    public O getObject() {
        return this.object;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public <E> LocatedObject<? extends E> cast(Class<E> cls) {
        if (cls.isInstance(this.getObject())) {
            LocatedObject tmp = this;
            return tmp;
        }
        throw new ClassCastException();
    }

    public int hashCode() {
        return Objects.hash(this.object, this.location);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocatedObject)) {
            return false;
        }
        LocatedObject other = (LocatedObject)object;
        return Objects.equals(this.object, other.object) && Objects.equals(this.location, other.location);
    }

    public String toString() {
        return "[" + String.valueOf(this.object) + ", " + String.valueOf(this.location) + "]";
    }

    public static <O> LocatedObject<O> of(O object, Location location) {
        return new LocatedObject<O>(object, location);
    }

    public static <O extends LocatedItem> LocatedObject<O> of(O object) {
        return new LocatedObject<O>(object, object.getLocation());
    }

    public static <O extends LocatedItem> List<LocatedObject<? extends O>> locate(List<? extends O> list) {
        return list.stream().map(LocatedObject::of).collect(Collectors.toList());
    }
}

