/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.IssueSeverity;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Params;
import cdc.issues.rules.ConfiguredRule;
import cdc.issues.rules.ProfileConfig;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleConfig;
import cdc.issues.rules.RuleId;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface Profile {
    public String getName();

    public String getDescription();

    public Metas getMetas();

    public Labels getLabels();

    public Set<Rule> getRules();

    default public boolean hasRule(Rule rule) {
        return this.getRules().contains(rule);
    }

    default public Set<Rule> getEnabledRules() {
        return this.getRules().stream().filter(this::isEnabled).collect(Collectors.toSet());
    }

    public ProfileConfig getProfileConfig();

    default public boolean hasRule(RuleId ruleId) {
        return this.getProfileConfig().getRuleIds().contains(ruleId);
    }

    public Optional<Rule> getRule(RuleId var1);

    public ConfiguredRule getConfiguredRule(Rule var1);

    default public RuleConfig getRuleConfig(Rule rule) {
        return this.getConfiguredRule(rule).getConfig();
    }

    default public boolean isEnabled(Rule rule) {
        return this.getConfiguredRule(rule).isEnabled();
    }

    default public Optional<IssueSeverity> getCustomizedSeverity(Rule rule) {
        return this.getConfiguredRule(rule).getCustomizedSeverity();
    }

    default public IssueSeverity getEffectiveSeverity(Rule rule) {
        return this.getConfiguredRule(rule).getEffectiveSeverity();
    }

    default public Params getParams(Rule rule) {
        return this.getConfiguredRule(rule).getParams();
    }
}

