/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.IssueId;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueSeverityItem;
import cdc.issues.Labels;
import cdc.issues.LabelsBuilding;
import cdc.issues.LabelsItem;
import cdc.issues.Metas;
import cdc.issues.MetasBuilding;
import cdc.issues.MetasItem;
import cdc.issues.Params;
import cdc.issues.StructuredDescription;
import cdc.issues.locations.LocatedItem;
import cdc.issues.locations.Location;
import cdc.issues.rules.Rule;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class Issue
implements MetasItem,
LabelsItem {
    private static final String DESCRIPTION = "description";
    private static final String LABELS = "labels";
    private static final String LOCATION = "location";
    private static final String LOCATIONS = "locations";
    private static final String PARAMS = "params";
    private static final String SEVERITY = "severity";
    public static final Comparator<Issue> TIMESTAMP_COMPARATOR = Comparator.comparing(Issue::getTimestamp);
    private final Instant timestamp;
    private final IssueId id;
    private final String title;
    private final String snapshot;
    private final IssueSeverity severity;
    private final String description;
    private final Metas metas;
    private final Labels labels;

    protected Issue(Builder<?> builder) {
        this.timestamp = builder.timestamp == null ? Instant.now() : builder.timestamp;
        this.id = IssueId.builder().domain(builder.domain).name(builder.name).params(builder.params).project(builder.project).locations(builder.locations).build();
        this.title = builder.title;
        this.snapshot = builder.snapshot;
        this.severity = (IssueSeverity)((Object)Checks.isNotNull((Object)((Object)builder.severity), (String)SEVERITY));
        this.description = (String)Checks.isNotNull((Object)builder.description, (String)DESCRIPTION);
        this.metas = builder.metas.build();
        this.labels = (Labels)Checks.isNotNull((Object)builder.labels, (String)LABELS);
    }

    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public IssueId getId() {
        return this.id;
    }

    public String getIdHash() {
        return this.id.getHash();
    }

    public RuleId getRuleId() {
        return this.id.getRuleId();
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> typeClass) {
        return this.id.getName(typeClass);
    }

    public String getTitle() {
        return this.title;
    }

    public Params getParams() {
        return this.id.getParams();
    }

    public String getProject() {
        return this.id.getProject();
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public final IssueSeverity getSeverity() {
        return this.severity;
    }

    public final String getDescription() {
        return this.description;
    }

    @Override
    public Metas getMetas() {
        return this.metas;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    public Location[] getLocations() {
        return this.id.getLocations();
    }

    public final int getNumberOfLocations() {
        return this.id.getLocations().length;
    }

    public Location getLocationAt(int index) {
        return this.id.getLocations()[index];
    }

    public <L extends Location> L getLocationAt(int index, Class<L> cls) {
        return (L)((Location)cls.cast(this.getLocationAt(index)));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.id, this.title, this.snapshot, this.severity, this.description, this.metas, this.labels});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Issue other = (Issue)object;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.id, other.id) && Objects.equals(this.title, other.title) && Objects.equals(this.snapshot, other.snapshot) && this.severity == other.severity && Objects.equals(this.description, other.description) && Objects.equals(this.metas, other.metas) && Objects.equals(this.labels, other.labels);
    }

    public String toString() {
        return String.valueOf(this.getTimestamp()) + " - " + this.getDomain() + " - " + this.getName() + " - " + this.getTitle() + " - " + String.valueOf(this.getParams()) + " - " + this.getProject() + " - " + this.getSnapshot() + " - " + String.valueOf((Object)this.getSeverity()) + " - " + this.getDescription() + " - " + Arrays.toString(this.getLocations()) + " - " + String.valueOf(this.getMetas()) + " - " + String.valueOf(this.getLabels());
    }

    public static Builder<?> builder() {
        return new Builder();
    }

    public static class Builder<B extends Builder<B>>
    implements MetasBuilding<B>,
    LabelsBuilding<B> {
        protected Instant timestamp = null;
        protected String domain;
        protected String name;
        protected String title;
        protected Params params = Params.NO_PARAMS;
        protected String project;
        protected String snapshot;
        protected IssueSeverity severity;
        protected String description = "";
        protected final List<Location> locations = new ArrayList<Location>();
        protected Metas.Builder metas = Metas.builder();
        protected Labels labels = Labels.NO_LABELS;

        protected Builder() {
        }

        @Override
        public B self() {
            return (B)this;
        }

        public B accept(Consumer<? super B> consumer) {
            consumer.accept(this.self());
            return (B)this.self();
        }

        public B issue(Issue issue) {
            this.timestamp(issue.getTimestamp());
            this.domain(issue.getDomain());
            this.name(issue.getName());
            this.title(issue.getTitle());
            this.params(issue.getParams());
            this.project(issue.getProject());
            this.snapshot(issue.getSnapshot());
            this.severity(issue.getSeverity());
            this.description(issue.getDescription());
            this.locations(issue.getLocations());
            this.metas(issue.getMetas());
            this.labels(issue.getLabels());
            return (B)this.self();
        }

        public B timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        public B rule(Rule rule) {
            this.domain = rule.getDomain();
            this.name = rule.getName();
            this.title = rule.getTitle();
            this.severity = rule.getSeverity();
            return (B)this.self();
        }

        public B ruleId(RuleId ruleId) {
            this.domain = ruleId.getDomain();
            this.name = ruleId.getName();
            return (B)this.self();
        }

        public B domain(String domain) {
            this.domain = domain;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B name(Enum<?> name) {
            IssueSeverityItem isi;
            IssueSeverity s;
            this.name = name.name();
            if (this.severity == null && name instanceof IssueSeverityItem && (s = (isi = (IssueSeverityItem)((Object)name)).getSeverity()) != null) {
                this.severity(s);
            }
            return (B)this.self();
        }

        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        public B params(Params params) {
            Checks.isNotNull((Object)params, (String)Issue.PARAMS);
            this.params = params;
            return (B)this.self();
        }

        public B project(String project) {
            this.project = project;
            return (B)this.self();
        }

        public B addLocation(Location location) {
            Checks.isNotNull((Object)location, (String)Issue.LOCATION);
            this.locations.add(location);
            return (B)this.self();
        }

        public B location(Location location) {
            Checks.isNotNull((Object)location, (String)Issue.LOCATION);
            this.locations.clear();
            this.locations.add(location);
            return (B)this.self();
        }

        public B location(LocatedItem item) {
            return this.location(item.getLocation());
        }

        public B locations(Location ... locations) {
            Checks.isNotNull((Object)locations, (String)Issue.LOCATIONS);
            this.locations.clear();
            Collections.addAll(this.locations, locations);
            return (B)this.self();
        }

        public B locations(List<? extends Location> locations) {
            Checks.isNotNull(locations, (String)Issue.LOCATIONS);
            this.locations.clear();
            this.locations.addAll(locations);
            return (B)this.self();
        }

        public B snapshot(String snapshot) {
            this.snapshot = snapshot;
            return (B)this.self();
        }

        public B severity(IssueSeverity severity) {
            Checks.isNotNull((Object)((Object)severity), (String)Issue.SEVERITY);
            this.severity = severity;
            return (B)this.self();
        }

        public B description(String description) {
            Checks.isNotNull((Object)description, (String)Issue.DESCRIPTION);
            this.description = description;
            return (B)this.self();
        }

        public B description(StructuredDescription.Builder<?> description) {
            Checks.isNotNull(description, (String)Issue.DESCRIPTION);
            this.description = description.build().toString();
            return (B)this.self();
        }

        public B description(Object description) {
            Checks.isNotNull((Object)description, (String)Issue.DESCRIPTION);
            return this.description(description.toString());
        }

        @Override
        public B meta(String name, String value) {
            this.metas.meta(name, value);
            return (B)this.self();
        }

        @Override
        public B meta(String name, String value, String separator) {
            this.metas.meta(name, value, separator);
            return (B)this.self();
        }

        @Override
        public B metas(Metas metas) {
            this.metas.metas(metas);
            return (B)this.self();
        }

        @Override
        public B labels(Labels labels) {
            Checks.isNotNull((Object)labels, (String)Issue.LABELS);
            this.labels = labels;
            return (B)this.self();
        }

        public Issue build() {
            return new Issue(this);
        }
    }
}

