/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Param;
import cdc.issues.Params;
import cdc.issues.locations.Location;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public final class IssueId
implements Comparable<IssueId> {
    private static final String DOMAIN = "domain";
    private static final String LOCATION = "location";
    private static final String LOCATIONS = "locations";
    private static final String NAME = "name";
    private static final String PARAMS = "params";
    private static final String RULE_ID = "ruleId";
    private final RuleId ruleId;
    private final Params params;
    private final String project;
    private final Location[] locations;
    private String hash = null;
    private static final Comparator<String> STRING_COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());

    private IssueId(Builder builder) {
        this.ruleId = new RuleId(builder.domain, builder.name);
        this.params = (Params)Checks.isNotNull((Object)builder.params, (String)PARAMS);
        this.project = builder.project;
        this.locations = (Location[])((Location[])Checks.isNotNull((Object)builder.locations, (String)LOCATIONS)).clone();
    }

    public RuleId getRuleId() {
        return this.ruleId;
    }

    public String getDomain() {
        return this.ruleId.getDomain();
    }

    public String getName() {
        return this.ruleId.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.ruleId.getName(cls);
    }

    public Params getParams() {
        return this.params;
    }

    public String getProject() {
        return this.project;
    }

    public Location[] getLocations() {
        return (Location[])this.locations.clone();
    }

    public String getHash() {
        if (this.hash == null) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getDomain());
            builder.append('/');
            builder.append(this.getName());
            builder.append('[');
            boolean first = true;
            for (Param param : this.getParams().getSortedParams()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(param.getName());
                builder.append('=');
                builder.append(param.getValue());
            }
            builder.append(']');
            builder.append(this.getProject());
            builder.append('[');
            first = true;
            for (Location location : this.getLocations()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(',');
                }
                builder.append(location);
            }
            builder.append(']');
            this.hash = DigestUtils.sha1Hex((String)builder.toString());
        }
        return this.hash;
    }

    public int hashCode() {
        return Objects.hash(this.ruleId, this.params, this.project) + 31 * Arrays.hashCode(this.locations);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueId)) {
            return false;
        }
        IssueId other = (IssueId)object;
        return this.ruleId.equals(other.ruleId) && Objects.equals(this.params, other.params) && Objects.equals(this.project, other.project) && Arrays.equals(this.locations, other.locations);
    }

    @Override
    public int compareTo(IssueId other) {
        int ruleIdCmp = this.ruleId.compareTo(other.ruleId);
        if (ruleIdCmp != 0) {
            return ruleIdCmp;
        }
        int paramsCmp = this.params.compareTo(other.params);
        if (paramsCmp != 0) {
            return paramsCmp;
        }
        int projectCmp = STRING_COMPARATOR.compare(this.project, other.project);
        if (projectCmp != 0) {
            return projectCmp;
        }
        return Arrays.compare((Comparable[])this.locations, (Comparable[])other.locations);
    }

    public String toString() {
        return "[" + String.valueOf(this.ruleId) + " " + String.valueOf(this.params) + " " + this.project + " " + Arrays.toString(this.locations) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String domain;
        private String name;
        private Params params = Params.NO_PARAMS;
        private String project;
        private Location[] locations = new Location[0];

        private Builder() {
        }

        public Builder ruleId(RuleId ruleId) {
            Checks.isNotNull((Object)ruleId, (String)IssueId.RULE_ID);
            this.domain = ruleId.getDomain();
            this.name = ruleId.getName();
            return this;
        }

        public Builder domain(String domain) {
            this.domain = (String)Checks.isNotNull((Object)domain, (String)IssueId.DOMAIN);
            return this;
        }

        public Builder name(String name) {
            this.name = (String)Checks.isNotNull((Object)name, (String)IssueId.NAME);
            return this;
        }

        public Builder name(Enum<?> name) {
            this.name = ((Enum)Checks.isNotNull(name, (String)IssueId.NAME)).name();
            return this;
        }

        public Builder params(Params params) {
            this.params = (Params)Checks.isNotNull((Object)params, (String)IssueId.PARAMS);
            return this;
        }

        public Builder project(String project) {
            this.project = project;
            return this;
        }

        public Builder location(Location location) {
            this.locations = new Location[]{(Location)Checks.isNotNull((Object)location, (String)IssueId.LOCATION)};
            return this;
        }

        public Builder locations(Location ... locations) {
            this.locations = (Location[])Checks.isNotNull((Object)locations, (String)IssueId.LOCATIONS);
            return this;
        }

        public Builder locations(List<? extends Location> locations) {
            Checks.isNotNull(locations, (String)IssueId.LOCATIONS);
            this.locations = locations.toArray(new Location[locations.size()]);
            return this;
        }

        public IssueId build() {
            return new IssueId(this);
        }
    }
}

