/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssueId;
import cdc.issues.IssueUtils;
import cdc.issues.IssuesCountItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IssuesCounter
implements IssuesCountItem {
    private final boolean computeHash;
    private int count = 0;
    private final List<IssueId> ids;
    private String hash = null;

    public IssuesCounter(boolean computeHash) {
        this.computeHash = computeHash;
        this.ids = computeHash ? new ArrayList() : Collections.emptyList();
    }

    public void consume(Issue issue) {
        ++this.count;
        if (this.computeHash) {
            this.hash = null;
            this.ids.add(issue.getId());
        }
    }

    @Override
    public int getNumberOfIssues() {
        return this.count;
    }

    @Override
    public String getIssuesHash() {
        if (this.hash == null && this.computeHash) {
            this.hash = IssueUtils.getHash(this.ids);
        }
        return this.hash;
    }
}

