/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Issue;
import cdc.issues.IssuesCountItem;
import cdc.issues.IssuesCounter;
import cdc.issues.IssuesHandler;

public interface IssuesCountingHandler
extends IssuesHandler,
IssuesCountItem {
    public static IssuesCountingHandler of(final IssuesHandler handler, final boolean computeHash) {
        if (handler instanceof IssuesCountingHandler) {
            IssuesCountingHandler x = (IssuesCountingHandler)handler;
            return x;
        }
        return new IssuesCountingHandler(){
            private final IssuesCounter counter;
            {
                this.counter = new IssuesCounter(computeHash);
            }

            @Override
            public int getNumberOfIssues() {
                return this.counter.getNumberOfIssues();
            }

            @Override
            public String getIssuesHash() {
                return this.counter.getIssuesHash();
            }

            @Override
            public void issue(Issue issue) {
                this.counter.consume(issue);
                handler.issue(issue);
            }
        };
    }
}

