/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.answers;

import cdc.issues.IssueId;
import cdc.issues.IssueSeverity;
import cdc.issues.Labels;
import cdc.issues.LabelsBuilding;
import cdc.issues.LabelsItem;
import cdc.issues.Metas;
import cdc.issues.MetasBuilding;
import cdc.issues.MetasItem;
import cdc.issues.answers.IssueAnswerImpl;
import cdc.issues.answers.IssueComment;
import cdc.issues.answers.IssueResolution;
import cdc.issues.answers.IssueStatus;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public interface IssueAnswer
extends MetasItem,
LabelsItem {
    public IssueId getIssueId();

    public String getAuthor();

    public Instant getCreationDate();

    public Instant getModificationDate();

    public IssueStatus getStatus();

    public IssueResolution getResolution();

    public String getAssignee();

    public IssueSeverity getNewSeverity();

    public List<? extends IssueComment> getComments();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements MetasBuilding<Builder>,
    LabelsBuilding<Builder> {
        IssueId issueId;
        String author;
        Instant creationDate;
        Instant modificationDate;
        IssueStatus status = IssueStatus.OPEN;
        IssueResolution resolution = IssueResolution.UNRESOLVED;
        String assignee;
        IssueSeverity newSeverity;
        final List<IssueComment> comments = new ArrayList<IssueComment>();
        final Metas.Builder metas = Metas.builder();
        Labels labels = Labels.NO_LABELS;

        protected Builder() {
        }

        public Builder issueId(IssueId issueId) {
            this.issueId = issueId;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder modificationDate(Instant modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public Builder status(IssueStatus status) {
            this.status = status;
            return this;
        }

        public Builder resolution(IssueResolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public Builder assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        public Builder newSeverity(IssueSeverity newSeverity) {
            this.newSeverity = newSeverity;
            return this;
        }

        public Builder comment(IssueComment comment) {
            this.comments.add(comment);
            return this;
        }

        public Builder comments(List<? extends IssueComment> comments) {
            this.comments.addAll(comments);
            return this;
        }

        @Override
        public Builder meta(String name, String value) {
            this.metas.meta(name, value);
            return (Builder)this.self();
        }

        @Override
        public Builder meta(String name, String value, String separator) {
            this.metas.meta(name, value, separator);
            return (Builder)this.self();
        }

        @Override
        public Builder metas(Metas metas) {
            this.metas.metas(metas);
            return (Builder)this.self();
        }

        @Override
        public Builder labels(Labels labels) {
            this.labels = labels;
            return this;
        }

        public IssueAnswer build() {
            Instant cd = this.creationDate == null ? Instant.now() : this.creationDate;
            return new IssueAnswerImpl(this.issueId, this.author, cd, this.modificationDate == null ? cd : this.modificationDate, this.status, this.resolution, this.assignee, this.newSeverity, List.copyOf(this.comments), this.metas.build(), this.labels);
        }
    }
}

