/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.answers;

import cdc.issues.answers.IssueCommentImpl;
import java.time.Instant;

public interface IssueComment {
    public String getAuthor();

    public Instant getDate();

    public String getText();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String author;
        Instant date;
        String text;

        protected Builder() {
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public IssueComment build() {
            return new IssueCommentImpl(this.author, this.date == null ? Instant.now() : this.date, this.text);
        }
    }
}

