/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.answers;

import cdc.issues.answers.IssueResolution;
import cdc.util.lang.UnexpectedValueException;

public enum IssueStatus {
    OPEN,
    CONFIRMED,
    WAITING,
    RESOLVED,
    REOPENED,
    CLOSED;


    public boolean isCompliantWith(IssueResolution resolution) {
        if (resolution == IssueResolution.UNRESOLVED) {
            return this == OPEN || this == REOPENED || this == CONFIRMED || this == WAITING;
        }
        if (resolution == IssueResolution.REMOVED) {
            return this == CLOSED;
        }
        if (resolution == IssueResolution.FIXED || resolution == IssueResolution.FALSE_POSITIVE || resolution == IssueResolution.WONT_FIX) {
            return this == CLOSED || this == RESOLVED;
        }
        throw new UnexpectedValueException((Enum)resolution);
    }
}

