/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.io.IssuesFormat;
import cdc.issues.io.IssuesIoFactoryFeatures;
import cdc.issues.io.IssuesReader;
import cdc.issues.io.IssuesStreamWriter;
import cdc.issues.io.IssuesWriter;
import cdc.issues.io.OutSettings;
import cdc.util.lang.Checks;
import cdc.util.lang.FailureReaction;
import cdc.util.lang.Introspection;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class IssuesIoFactory {
    private static final String FILE = "file";
    private static final String FORMAT = "format";
    private static final String IN = "in";
    private static final String OUT = "out";
    private static final String SETTINGS = "settings";
    private final IssuesIoFactoryFeatures features;

    public IssuesIoFactory(IssuesIoFactoryFeatures features) {
        this.features = (IssuesIoFactoryFeatures)Checks.isNotNull((Object)features, (String)"features");
    }

    public IssuesIoFactoryFeatures getFeatures() {
        return this.features;
    }

    public boolean canExportTo(File file) {
        if (file == null) {
            return false;
        }
        return IssuesFormat.from(file) != null;
    }

    public IssuesStreamWriter createIssuesStreamWriter(File file, OutSettings settings) {
        Checks.isNotNull((Object)file, (String)FILE);
        Checks.isNotNull((Object)settings, (String)SETTINGS);
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.WorkbookIssuesStreamWriter", file, settings);
                }
                case JSON: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.JsonIssuesStreamWriter", file, settings);
                }
                case XML: {
                    return this.createIssuesStreamWriter("cdc.issues.core.io.XmlIssuesStreamWriter", file, settings);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesStreamWriter for " + String.valueOf(file));
    }

    public IssuesStreamWriter createIssuesStreamWriter(OutputStream out, IssuesFormat format, OutSettings settings) {
        Checks.isNotNull((Object)out, (String)OUT);
        Checks.isNotNull((Object)((Object)format), (String)FORMAT);
        Checks.isNotNull((Object)settings, (String)SETTINGS);
        switch (format) {
            case CSV: 
            case ODS: 
            case XLS: 
            case XLSM: 
            case XLSX: {
                return this.createIssuesStreamWriter("cdc.issues.core.io.WorkbookIssuesStreamWriter", out, format, settings);
            }
            case JSON: {
                return this.createIssuesStreamWriter("cdc.issues.core.io.JsonIssuesStreamWriter", out, format, settings);
            }
            case XML: {
                return this.createIssuesStreamWriter("cdc.issues.core.io.XmlIssuesStreamWriter", out, format, settings);
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesStreamWriter for " + String.valueOf((Object)format));
    }

    public IssuesWriter createIssuesWriter(File file) {
        Checks.isNotNull((Object)file, (String)FILE);
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: 
                case JSON: 
                case XML: {
                    return this.createIssuesWriter("cdc.issues.core.io.IssuesWriterImpl", file);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesWriter for " + String.valueOf(file));
    }

    public IssuesWriter createIssuesWriter(OutputStream out, IssuesFormat format) {
        Checks.isNotNull((Object)out, (String)OUT);
        Checks.isNotNull((Object)((Object)format), (String)FORMAT);
        switch (format) {
            case CSV: 
            case ODS: 
            case XLS: 
            case XLSM: 
            case XLSX: 
            case JSON: 
            case XML: {
                return this.createIssuesWriter("cdc.issues.core.io.IssuesWriterImpl", out, format);
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesWriter for " + String.valueOf((Object)format));
    }

    private IssuesStreamWriter createIssuesStreamWriter(String className, File file, OutSettings settings) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesStreamWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{File.class, OutSettings.class, IssuesIoFactoryFeatures.class};
        return (IssuesStreamWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{file, settings, this.getFeatures()});
    }

    private IssuesStreamWriter createIssuesStreamWriter(String className, OutputStream out, IssuesFormat format, OutSettings settings) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesStreamWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{OutputStream.class, IssuesFormat.class, OutSettings.class, IssuesIoFactoryFeatures.class};
        return (IssuesStreamWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{out, format, settings, this.getFeatures()});
    }

    private IssuesWriter createIssuesWriter(String className, File file) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{File.class, IssuesIoFactoryFeatures.class};
        return (IssuesWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{file, this.getFeatures()});
    }

    private IssuesWriter createIssuesWriter(String className, OutputStream out, IssuesFormat format) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesWriter.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{OutputStream.class, IssuesFormat.class, IssuesIoFactoryFeatures.class};
        return (IssuesWriter)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{out, format, this.getFeatures()});
    }

    public boolean canImportFrom(File file) {
        if (file == null) {
            return false;
        }
        return IssuesFormat.from(file) != null;
    }

    public IssuesReader createIssuesReader(File file) {
        Checks.isNotNull((Object)file, (String)FILE);
        IssuesFormat format = IssuesFormat.from(file);
        if (format != null) {
            switch (format) {
                case CSV: 
                case ODS: 
                case XLS: 
                case XLSM: 
                case XLSX: {
                    return this.createIssuesReader("cdc.issues.core.io.WorkbookIssuesReader", file);
                }
                case JSON: {
                    return this.createIssuesReader("cdc.issues.core.io.JsonIssuesReader", file);
                }
                case XML: {
                    return this.createIssuesReader("cdc.issues.core.io.XmlIssuesReader", file);
                }
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesReader for " + String.valueOf(file));
    }

    public IssuesReader createIssuesReader(InputStream in, IssuesFormat format) {
        Checks.isNotNull((Object)in, (String)IN);
        Checks.isNotNull((Object)((Object)format), (String)FORMAT);
        switch (format) {
            case CSV: 
            case ODS: 
            case XLS: 
            case XLSM: 
            case XLSX: {
                return this.createIssuesReader("cdc.issues.core.io.WorkbookIssuesReader", in, format);
            }
            case JSON: {
                return this.createIssuesReader("cdc.issues.core.io.JsonIssuesReader", in, format);
            }
            case XML: {
                return this.createIssuesReader("cdc.issues.core.io.XmlIssuesReader", in, format);
            }
        }
        throw new IllegalArgumentException("Can not create an IssuesReader for " + String.valueOf((Object)format));
    }

    private IssuesReader createIssuesReader(String className, File file) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesReader.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{File.class, IssuesIoFactoryFeatures.class};
        return (IssuesReader)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{file, this.getFeatures()});
    }

    private IssuesReader createIssuesReader(String className, InputStream in, IssuesFormat format) {
        Class cls = Introspection.uncheckedCast((Class)Introspection.getClass((String)className, IssuesReader.class, (FailureReaction)FailureReaction.FAIL));
        Class[] parameterTypes = new Class[]{InputStream.class, IssuesFormat.class, IssuesIoFactoryFeatures.class};
        return (IssuesReader)Introspection.newInstance((Class)cls, (Class[])parameterTypes, (FailureReaction)FailureReaction.FAIL, (Object[])new Object[]{in, format, this.getFeatures()});
    }
}

