/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.office.ss.WorkbookKind;
import cdc.util.files.Files;
import cdc.util.lang.UnexpectedValueException;
import java.io.File;

public enum ProfileFormat {
    CSV,
    ODS,
    XLS,
    XLSM,
    XLSX,
    JSON,
    XML,
    HTML,
    MD;


    public WorkbookKind getWorkbookKind() {
        switch (this) {
            case CSV: {
                return WorkbookKind.CSV;
            }
            case ODS: {
                return WorkbookKind.ODS;
            }
            case XLS: {
                return WorkbookKind.XLS;
            }
            case XLSX: {
                return WorkbookKind.XLSX;
            }
            case XLSM: {
                return WorkbookKind.XLSM;
            }
        }
        throw new UnexpectedValueException((Enum)this);
    }

    public boolean isProfileExportFormat() {
        return true;
    }

    public boolean isProfileConfigExportFormat() {
        return this == CSV || this == ODS || this == XLS || this == XLSX || this == XLSM;
    }

    public boolean isProfileImportFormat() {
        return this == XML;
    }

    public boolean isProfileConfigImportFormat() {
        return this == CSV || this == ODS || this == XLS || this == XLSX || this == XLSM;
    }

    public static ProfileFormat from(File file) {
        String ext = Files.getExtension((File)file);
        for (ProfileFormat format : ProfileFormat.values()) {
            if (!format.name().equalsIgnoreCase(ext)) continue;
            return format;
        }
        return null;
    }
}

