/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.IssueUtils;
import cdc.issues.IssuesCountItem;
import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.Project;
import cdc.issues.Snapshot;
import cdc.issues.io.SnapshotDataImpl;
import cdc.issues.rules.Profile;
import java.time.Instant;
import java.util.Optional;

public interface SnapshotData
extends IssuesCountItem {
    public String getProjectName();

    public String getProjectDescription();

    public Metas getProjectMetas();

    public Labels getProjectLabels();

    public Optional<? extends Profile> getProfile();

    public String getSnapshotName();

    public String getSnapshotDescription();

    public Metas getSnapshotMetas();

    public Labels getSnapshotLabels();

    public Instant getSnapshotTimestamp();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String projectName;
        String projectDescription;
        Metas projectMetas = Metas.NO_METAS;
        Labels projectLabels = Labels.NO_LABELS;
        Profile profile;
        String snapshotName;
        String snapshotDescription;
        Metas snapshotMetas = Metas.NO_METAS;
        Labels snapshotLabels = Labels.NO_LABELS;
        Instant snapshotTimestamp = Instant.now();
        int numberOfIssues = -1;
        String issuesHash = "";

        protected Builder self() {
            return this;
        }

        public Builder snapshot(Snapshot snapshot) {
            Project project = snapshot.getProject().orElse(null);
            if (project != null) {
                this.projectName(project.getName());
                this.projectDescription(project.getDescription());
                this.projectMetas(project.getMetas());
                this.projectLabels(project.getLabels());
                if (project.getProfile().isPresent()) {
                    this.profile(project.getProfile().orElseThrow());
                }
            }
            this.snapshotName(snapshot.getName());
            this.snapshotDescription(snapshot.getDescription());
            this.snapshotMetas(snapshot.getMetas());
            this.snapshotTimestamp(snapshot.getTimestamp());
            this.numberOfIssues(snapshot.getIssues().size());
            this.issuesHash(IssueUtils.getHash(snapshot.getIssues()));
            return this.self();
        }

        public Builder projectName(String name) {
            this.projectName = name;
            return this.self();
        }

        public Builder projectDescription(String description) {
            this.projectDescription = description;
            return this.self();
        }

        public Builder projectMetas(Metas metas) {
            this.projectMetas = metas;
            return this.self();
        }

        public Builder projectLabels(Labels labels) {
            this.projectLabels = labels;
            return this.self();
        }

        public Builder profile(Profile profile) {
            this.profile = profile;
            return this.self();
        }

        public Builder snapshotName(String name) {
            this.snapshotName = name;
            return this.self();
        }

        public Builder snapshotDescription(String description) {
            this.snapshotDescription = description;
            return this.self();
        }

        public Builder snapshotMetas(Metas metas) {
            this.snapshotMetas = metas;
            return this.self();
        }

        public Builder snapshotLabels(Labels labels) {
            this.snapshotLabels = labels;
            return this.self();
        }

        public Builder snapshotTimestamp(Instant timestamp) {
            this.snapshotTimestamp = timestamp;
            return this.self();
        }

        public Builder numberOfIssues(int number) {
            this.numberOfIssues = number;
            return this.self();
        }

        public Builder issuesHash(String hash) {
            this.issuesHash = hash;
            return this.self();
        }

        public SnapshotData build() {
            return new SnapshotDataImpl(this);
        }
    }
}

