/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.Labels;
import cdc.issues.Metas;
import cdc.issues.io.SnapshotData;
import cdc.issues.rules.Profile;
import cdc.util.lang.Checks;
import java.time.Instant;
import java.util.Optional;

class SnapshotDataImpl
implements SnapshotData {
    private final String projectName;
    private final String projectDescription;
    private final Metas projectMetas;
    private final Labels projectLabels;
    private final Optional<Profile> profile;
    private final String snapshotName;
    private final String snapshotDescription;
    private final Metas snapshotMetas;
    private final Labels snapshotLabels;
    private final Instant snapshotTimestamp;
    private final int numberOfIssues;
    private final String issuesHash;

    SnapshotDataImpl(SnapshotData.Builder builder) {
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.projectMetas = (Metas)Checks.isNotNull((Object)builder.projectMetas, (String)"projectMetas");
        this.projectLabels = (Labels)Checks.isNotNull((Object)builder.projectLabels, (String)"projectLabels");
        this.profile = Optional.ofNullable(builder.profile);
        this.snapshotName = builder.snapshotName;
        this.snapshotDescription = builder.snapshotDescription;
        this.snapshotMetas = (Metas)Checks.isNotNull((Object)builder.snapshotMetas, (String)"snapshotMetas");
        this.snapshotLabels = (Labels)Checks.isNotNull((Object)builder.snapshotLabels, (String)"snapshotLabels");
        this.snapshotTimestamp = (Instant)Checks.isNotNull((Object)builder.snapshotTimestamp, (String)"snapshotTimestamp");
        this.numberOfIssues = builder.numberOfIssues;
        this.issuesHash = builder.issuesHash;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getProjectDescription() {
        return this.projectDescription;
    }

    @Override
    public Metas getProjectMetas() {
        return this.projectMetas;
    }

    @Override
    public Labels getProjectLabels() {
        return this.projectLabels;
    }

    public Optional<Profile> getProfile() {
        return this.profile;
    }

    @Override
    public String getSnapshotName() {
        return this.snapshotName;
    }

    @Override
    public String getSnapshotDescription() {
        return this.snapshotDescription;
    }

    @Override
    public Metas getSnapshotMetas() {
        return this.snapshotMetas;
    }

    @Override
    public Labels getSnapshotLabels() {
        return this.snapshotLabels;
    }

    @Override
    public Instant getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public int getNumberOfIssues() {
        return this.numberOfIssues;
    }

    @Override
    public String getIssuesHash() {
        return this.issuesHash;
    }

    public static SnapshotData.Builder builder() {
        return new SnapshotData.Builder();
    }
}

