/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.io;

import cdc.issues.Issue;
import cdc.issues.IssuesCounter;
import cdc.issues.IssuesCountingHandler;
import cdc.issues.io.IssuesFormat;
import cdc.issues.io.IssuesIoFactory;
import cdc.issues.io.IssuesIoFactoryFeatures;
import cdc.issues.io.IssuesStreamWriter;
import cdc.issues.io.OutSettings;
import cdc.issues.io.SnapshotData;
import cdc.util.lang.Checks;
import cdc.util.lang.ExceptionWrapper;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;

public class StreamIssuesHandler
implements IssuesCountingHandler,
Flushable,
Closeable {
    private final IssuesStreamWriter writer;
    private final IssuesCounter counter;

    protected StreamIssuesHandler(Builder builder) {
        Checks.isNotNull((Object)builder.settings, (String)"settings");
        Checks.isTrue((builder.file != null || builder.out != null ? 1 : 0) != 0, (String)"File and output stream are null.");
        IssuesIoFactory factory = new IssuesIoFactory((IssuesIoFactoryFeatures)Checks.isNotNull((Object)builder.features, (String)"features"));
        this.counter = new IssuesCounter(builder.computeHash);
        if (builder.file != null) {
            this.writer = factory.createIssuesStreamWriter(builder.file, builder.settings);
        } else {
            Checks.isNotNull((Object)((Object)builder.format), (String)"format");
            this.writer = factory.createIssuesStreamWriter(builder.out, builder.format, builder.settings);
        }
        ExceptionWrapper.wrap(() -> this.writer.startDocument());
        if (builder.snapshot != null) {
            ExceptionWrapper.wrap(() -> this.writer.add(builder.snapshot));
        }
    }

    @Override
    public void issue(Issue issue) {
        this.counter.consume(issue);
        ExceptionWrapper.wrap(() -> this.writer.add(issue));
    }

    @Override
    public int getNumberOfIssues() {
        return this.counter.getNumberOfIssues();
    }

    @Override
    public String getIssuesHash() {
        return this.counter.getIssuesHash();
    }

    @Override
    public void close() throws IOException {
        this.writer.endDocument();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IssuesIoFactoryFeatures features = IssuesIoFactoryFeatures.UTC_FASTEST;
        private OutSettings settings = OutSettings.ALL_DATA_NO_ANSWERS;
        private File file;
        private OutputStream out;
        private IssuesFormat format = IssuesFormat.CSV;
        private SnapshotData snapshot;
        private boolean computeHash = false;

        protected Builder self() {
            return this;
        }

        public Builder features(IssuesIoFactoryFeatures features) {
            this.features = features;
            return this.self();
        }

        public Builder settings(OutSettings settings) {
            this.settings = settings;
            return this.self();
        }

        public Builder file(File file) {
            this.out = null;
            this.file = file;
            return this.self();
        }

        public Builder out(OutputStream out) {
            this.file = null;
            this.out = out;
            return this.self();
        }

        public Builder format(IssuesFormat format) {
            this.format = format;
            return this.self();
        }

        public Builder snapshot(SnapshotData snapshot) {
            this.snapshot = snapshot;
            return this.self();
        }

        public Builder computeHash(boolean computeHash) {
            this.computeHash = computeHash;
            return this.self();
        }

        public StreamIssuesHandler build() {
            return new StreamIssuesHandler(this);
        }
    }
}

