/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.IssueSeverity;
import cdc.issues.Params;
import cdc.issues.rules.ProfileConfigImpl;
import cdc.issues.rules.RuleConfig;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface ProfileConfig {
    public Set<RuleId> getRuleIds();

    public Optional<RuleConfig> getRuleConfig(RuleId var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final String RULE_ID = "ruleId";
        private static final String RULE_CONFIG = "ruleConfig";
        final Map<RuleId, RuleConfig> configs = new HashMap<RuleId, RuleConfig>();

        Builder() {
        }

        protected Builder self() {
            return this;
        }

        public Builder addIfMissing(RuleId ruleId) {
            if (!this.configs.containsKey(ruleId)) {
                this.set(ruleId, RuleConfig.DEFAULT);
            }
            return this.self();
        }

        public Builder set(RuleId ruleId, RuleConfig ruleConfig) {
            Checks.isNotNull((Object)ruleId, (String)RULE_ID);
            Checks.isNotNull((Object)ruleConfig, (String)RULE_CONFIG);
            this.configs.put(ruleId, ruleConfig);
            return this.self();
        }

        public Builder setEnabled(RuleId ruleId, boolean enabled) {
            this.addIfMissing(ruleId);
            this.configs.put(ruleId, RuleConfig.builder().set(this.configs.get(ruleId)).enabled(enabled).build());
            return this.self();
        }

        public Builder setCustomizedSeverity(RuleId ruleId, IssueSeverity customizedSeverity) {
            this.addIfMissing(ruleId);
            this.configs.put(ruleId, RuleConfig.builder().set(this.configs.get(ruleId)).customizedSeverity(customizedSeverity).build());
            return this.self();
        }

        public Builder setParams(RuleId ruleId, Params params) {
            this.addIfMissing(ruleId);
            this.configs.put(ruleId, RuleConfig.builder().set(this.configs.get(ruleId)).params(params).build());
            return this.self();
        }

        public ProfileConfig build() {
            return new ProfileConfigImpl(this);
        }
    }
}

