/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.rules;

import cdc.issues.FormalParams;
import cdc.issues.IssueSeverity;
import cdc.issues.IssueSeverityItem;
import cdc.issues.Labels;
import cdc.issues.LabelsBuilding;
import cdc.issues.Metas;
import cdc.issues.MetasBuilding;
import cdc.issues.rules.RuleId;
import cdc.util.lang.Checks;
import cdc.util.strings.StringUtils;
import java.util.Comparator;
import java.util.Objects;

public class Rule {
    private static final String DESCRIPTION = "description";
    private static final String DOMAIN = "domain";
    private static final String LABELS = "labels";
    private static final String NAME = "name";
    private static final String PARAMS = "params";
    private static final String SEVERITY = "severity";
    public static final String DOMAIN_NAME_SEPARATOR = "-";
    private final RuleId id;
    private final String title;
    private final IssueSeverity severity;
    private final String description;
    private final FormalParams params;
    private final Metas metas;
    private final Labels labels;
    public static final Comparator<Rule> ID_COMPARATOR = Comparator.comparing(Rule::getId);
    public static final Comparator<Rule> DOMAIN_TITLE_NAME_COMPARATOR = Comparator.comparing(Rule::getDomain).thenComparing(r -> Rule.denullify(r.getTitle())).thenComparing(r -> r.getId().getName());

    private static String denullify(String s) {
        return s == null ? "" : s;
    }

    protected Rule(Builder builder) {
        this.id = new RuleId(builder.domain, builder.name);
        this.title = builder.title;
        this.severity = (IssueSeverity)((Object)Checks.isNotNull((Object)((Object)builder.severity), (String)SEVERITY));
        this.description = (String)Checks.isNotNull((Object)builder.description, (String)DESCRIPTION);
        this.params = (FormalParams)Checks.isNotNull((Object)builder.params, (String)PARAMS);
        this.metas = builder.metas.build();
        this.labels = (Labels)Checks.isNotNull((Object)builder.labels, (String)LABELS);
    }

    public RuleId getId() {
        return this.id;
    }

    public String getDomain() {
        return this.id.getDomain();
    }

    public String getName() {
        return this.id.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.id.getName(cls);
    }

    public String getTitle() {
        return this.title;
    }

    public IssueSeverity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public FormalParams getParams() {
        return this.params;
    }

    public Metas getMetas() {
        return this.metas;
    }

    public Labels getLabels() {
        return this.labels;
    }

    public String getRefDigest() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDomain()).append(DOMAIN_NAME_SEPARATOR).append(this.getName());
        if (!StringUtils.isNullOrEmpty((String)this.getTitle())) {
            builder.append(" ").append(this.getTitle());
        }
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.severity, this.description, this.params, this.metas, this.labels});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)object;
        return Objects.equals(this.id, other.id) && Objects.equals(this.title, other.title) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.description, other.description) && Objects.equals(this.params, other.params) && Objects.equals(this.metas, other.metas) && Objects.equals(this.labels, other.labels);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements MetasBuilding<Builder>,
    LabelsBuilding<Builder> {
        private String domain;
        private String name;
        private String title;
        private IssueSeverity severity;
        private String description = "";
        private FormalParams params = FormalParams.NO_PARAMS;
        private final Metas.Builder metas = Metas.builder();
        private Labels labels = Labels.NO_LABELS;

        protected Builder() {
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder id(RuleId id) {
            this.domain = id.getDomain();
            this.name = id.getName();
            return this;
        }

        public Builder domain(String domain) {
            Checks.isNotNull((Object)domain, (String)Rule.DOMAIN);
            this.domain = domain;
            return this;
        }

        public Builder name(String name) {
            Checks.isNotNull((Object)name, (String)Rule.NAME);
            this.name = name;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder name(Enum<?> name) {
            Checks.isNotNull(name, (String)Rule.NAME);
            this.name = name.name();
            if (this.severity == null && name instanceof IssueSeverityItem) {
                IssueSeverityItem isi = (IssueSeverityItem)((Object)name);
                this.severity = isi.getSeverity();
            }
            return this;
        }

        public Builder severity(IssueSeverity severity) {
            Checks.isNotNull((Object)((Object)severity), (String)Rule.SEVERITY);
            this.severity = severity;
            return this;
        }

        public Builder description(String description) {
            Checks.isNotNull((Object)description, (String)Rule.DESCRIPTION);
            this.description = description;
            return this;
        }

        public Builder params(FormalParams params) {
            Checks.isNotNull((Object)params, (String)Rule.PARAMS);
            this.params = params;
            return this;
        }

        @Override
        public Builder meta(String name, String value) {
            this.metas.meta(name, value);
            return this.self();
        }

        @Override
        public Builder meta(String name, String value, String separator) {
            this.metas.meta(name, value, separator);
            return this.self();
        }

        @Override
        public Builder metas(Metas metas) {
            this.metas.metas(metas);
            return this.self();
        }

        @Override
        public Builder labels(Labels labels) {
            Checks.isNotNull((Object)labels, (String)Rule.LABELS);
            this.labels = labels;
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }
    }
}

