/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.Meta;
import cdc.issues.Metas;
import cdc.issues.NameValue;
import cdc.util.lang.Checks;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

record MetasImpl(Map<String, String> map) implements Metas
{
    MetasImpl {
        for (String name : map.keySet()) {
            Checks.isTrue((boolean)Meta.isValidName(name), (String)"name: '{}'", (Object)name);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> getNames() {
        return this.map.keySet();
    }

    @Override
    public List<String> getSortedNames() {
        return this.map.keySet().stream().sorted().toList();
    }

    @Override
    public String getValue(String name) {
        return this.map.get(name);
    }

    @Override
    public String getValue(String name, String def) {
        return this.map.getOrDefault(name, def);
    }

    @Override
    public Collection<Meta> getMetas() {
        return this.map.keySet().stream().map(name -> Meta.of(name, this.getValue((String)name))).toList();
    }

    @Override
    public List<Meta> getSortedMetas() {
        return this.map.keySet().stream().sorted().map(name -> Meta.of(name, this.getValue((String)name))).toList();
    }

    @Override
    public String toString() {
        return this.getSortedMetas().stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    public Collection<? extends NameValue> getNameValues() {
        return this.getMetas();
    }

    @Override
    public List<? extends NameValue> getSortedNameValues() {
        return this.getSortedMetas();
    }
}

