/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues;

import cdc.issues.NameValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface NameValueMap {
    public boolean isEmpty();

    public Set<String> getNames();

    default public boolean containsName(String name) {
        return this.getNames().contains(name);
    }

    public List<String> getSortedNames();

    public String getValue(String var1);

    public String getValue(String var1, String var2);

    public Collection<? extends NameValue> getNameValues();

    public List<? extends NameValue> getSortedNameValues();

    public static abstract class Builder<M extends NameValueMap, B extends Builder<M, B>> {
        protected Map<String, String> map = new HashMap<String, String>();

        protected Builder() {
        }

        protected B self() {
            return (B)this;
        }

        public B entry(String name, String value) {
            this.map.put(name, value);
            return this.self();
        }

        public B entryIfNotNull(String name, String value) {
            if (value != null) {
                this.map.put(name, value);
            }
            return this.self();
        }

        public B entries(Collection<? extends NameValue> entries) {
            for (NameValue nameValue : entries) {
                this.map.put(nameValue.getName(), nameValue.getValue());
            }
            return this.self();
        }

        public B entries(NameValueMap other) {
            for (String name : other.getNames()) {
                this.map.put(name, other.getValue(name));
            }
            return this.self();
        }

        public B append(String name, String value, String separator) {
            if (this.map.containsKey(name)) {
                this.map.put(name, this.map.get(name) + separator + value);
            } else {
                this.map.put(name, value);
            }
            return this.self();
        }

        public abstract M build();
    }
}

