/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.IssueId;
import cdc.issues.api.Params;
import cdc.issues.api.locations.DefaultLocation;
import cdc.issues.api.locations.Location;
import cdc.issues.api.rules.RuleId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IssueIdTest {
    IssueIdTest() {
    }

    @Test
    void test() {
        DefaultLocation location = new DefaultLocation("Path", "Anchor");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new IssueId("Domain", "Name", Params.NO_PARAMS, new Location[0]));
        IssueId ida = new IssueId("Domain", "Name", Params.NO_PARAMS, new Location[]{location});
        IssueId idb = new IssueId("Domain", "Name", Params.NO_PARAMS, new Location[]{location});
        IssueId idc = new IssueId("Domain", "Name", new Location[]{location});
        IssueId idd = new IssueId(new RuleId("Domain", "Name"), new Location[]{location});
        IssueId ide = new IssueId("Domain", (Enum)Type.A, new Location[]{location});
        IssueId idf = new IssueId("Domain1", "Name", Params.NO_PARAMS, new Location[]{location});
        IssueId idg = new IssueId("Domain", "Name", Params.builder().param("name", "value").build(), new Location[]{location});
        IssueId idh = new IssueId("Domain", "Name", new Location[]{location, location});
        Assertions.assertEquals((Object)ida, (Object)ida);
        Assertions.assertEquals((Object)ida, (Object)idb);
        Assertions.assertEquals((Object)ida, (Object)idc);
        Assertions.assertEquals((Object)ida, (Object)idd);
        Assertions.assertNotEquals((Object)ida, null);
        Assertions.assertNotEquals((Object)ida, (Object)"hello");
        Assertions.assertNotEquals((Object)ida, (Object)ide);
        Assertions.assertNotEquals((Object)ida, (Object)idf);
        Assertions.assertNotEquals((Object)ida, (Object)idg);
        Assertions.assertNotEquals((Object)ida, (Object)idh);
        Assertions.assertEquals((Object)ida.toString(), (Object)idb.toString());
        Assertions.assertEquals((int)ida.hashCode(), (int)idb.hashCode());
        Assertions.assertEquals((Object)"A", (Object)ide.getName());
        Assertions.assertEquals((Object)((Object)Type.A), (Object)ide.getName(Type.class));
    }

    private static enum Type {
        A,
        B;

    }
}

