/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Issue;
import cdc.issues.api.IssueSeverity;
import cdc.issues.api.Params;
import cdc.issues.api.locations.Location;
import cdc.issues.api.locations.TextFileLocation;
import cdc.issues.api.rules.RuleId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IssueTest {
    IssueTest() {
    }

    @Test
    void test() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> Issue.builder().build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Issue.builder().domain("Domain").build());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Issue.builder().domain("Domain").name("Name").build());
        Issue issuea = Issue.builder().domain("Domain").name("Type").addLocation((Location)TextFileLocation.builder().systemId("file").build()).severity(IssueSeverity.BLOCKER).description("description").build();
        Issue issueb = Issue.builder().timestamp(issuea.getTimestamp()).domain("Domain").name("Type").addLocation((Location)TextFileLocation.builder().systemId("file").build()).severity(IssueSeverity.BLOCKER).description("description").build();
        Issue issuec = Issue.builder().timestamp(issuea.getTimestamp()).domain("Domain").name((Enum)Type.A).locations(new Location[]{TextFileLocation.builder().systemId("file").build()}).severity(IssueSeverity.BLOCKER).description("description").params(Params.builder().param("name", "value").build()).build();
        Issue issued = Issue.builder().timestamp(issuea.getTimestamp()).ruleId(new RuleId("Domain", (Enum)Type.A)).locations(new Location[]{TextFileLocation.builder().systemId("file").build()}).severity(IssueSeverity.BLOCKER).description("description").params(Params.builder().param("name", "value").build()).build();
        Assertions.assertEquals((Object)"Type", (Object)issuea.getName());
        Assertions.assertEquals((Object)issuea, (Object)issuea);
        Assertions.assertEquals((Object)issuea, (Object)issueb);
        Assertions.assertEquals((Object)issuec, (Object)issued);
        Assertions.assertNotEquals((Object)issuea, null);
        Assertions.assertNotEquals((Object)issuea, (Object)"hello");
        Assertions.assertEquals((Object)issuea.getId(), (Object)issueb.getId());
        Assertions.assertEquals((Object)issuea.getRuleId(), (Object)issueb.getRuleId());
        Assertions.assertEquals((Object)issuea.getDescription(), (Object)issueb.getDescription());
        Assertions.assertEquals((Object)issuea.getLocationAt(0), (Object)issueb.getLocationAt(0));
        Assertions.assertEquals((Object)issuea.getLocationAt(0, TextFileLocation.class), (Object)issueb.getLocationAt(0, TextFileLocation.class));
        Assertions.assertEquals((Object)IssueSeverity.BLOCKER, (Object)issuea.getSeverity());
        Assertions.assertEquals((int)1, (int)issuea.getNumberOfLocations());
        Assertions.assertEquals((Object)Params.NO_PARAMS, (Object)issuea.getParams());
        Assertions.assertEquals((Object)"Domain", (Object)issuea.getDomain());
        Assertions.assertEquals((Object)"Type", (Object)issuea.getName());
        Assertions.assertEquals((Object)((Object)Type.A), (Object)issuec.getName(Type.class));
        Assertions.assertEquals((Object)"A", (Object)issuec.getName());
        Assertions.assertEquals((Object)issuea.toString(), (Object)issueb.toString());
        Assertions.assertEquals((int)issuea.hashCode(), (int)issueb.hashCode());
    }

    private static enum Type {
        A,
        B;

    }
}

