/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.FormalParams;
import cdc.issues.api.Issue;
import cdc.issues.api.IssueSeverity;
import cdc.issues.api.IssuesCollector;
import cdc.issues.api.IssuesHandler;
import cdc.issues.api.Params;
import cdc.issues.api.VerboseIssuesHandler;
import cdc.issues.api.locations.DefaultLocatedData;
import cdc.issues.api.locations.DefaultLocation;
import cdc.issues.api.locations.Location;
import cdc.issues.api.rules.AbstractIssueDetector;
import cdc.issues.api.rules.CompositeRulesCatalog;
import cdc.issues.api.rules.DefaultRulesCatalog;
import cdc.issues.api.rules.IssuesDetector;
import cdc.issues.api.rules.Rule;
import cdc.issues.api.rules.RulesCatalog;
import cdc.util.events.ProgressController;
import cdc.util.lang.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RulesCatalogTest {
    private static final Logger LOGGER = LogManager.getLogger(RulesCatalogTest.class);
    static final Rule RULE1 = Rule.builder().domain("Domain").name("Rule1").severity(IssueSeverity.CRITICAL).description("Rule 1 description").build();
    static final Rule RULE2 = Rule.builder().domain("Domain").name("Rule2").severity(IssueSeverity.CRITICAL).description("Rule 2 description").build();
    static final Rule RULE3 = Rule.builder().domain("Domain").name("Rule3").severity(IssueSeverity.CRITICAL).description("Rule 3 description").build();
    static final IssuesDetector.Descriptor<String> DESCRIPTOR12 = new IssuesDetector.AbstractDescriptor<String>(String.class, new Rule[]{RULE1, RULE2}){

        public IssuesDetector<String> create(Params params, Set<Rule> rules) {
            return new Detector1(rules);
        }
    };

    RulesCatalogTest() {
    }

    @Test
    void test() {
        DefaultRulesCatalog catalog1 = new DefaultRulesCatalog().register(RULE1).register(RULE2).register(RULE3).register(DESCRIPTOR12);
        CompositeRulesCatalog ccatalog = new CompositeRulesCatalog().add((RulesCatalog)catalog1);
        Assertions.assertEquals((int)1, (int)catalog1.getDomains().size());
        Assertions.assertEquals((int)3, (int)catalog1.getRules().size());
        Assertions.assertEquals((int)3, (int)catalog1.getRules("Domain").size());
        Assertions.assertEquals((int)0, (int)catalog1.getRules("domain").size());
        Assertions.assertEquals((int)1, (int)catalog1.getDescriptors().size());
        Assertions.assertEquals((int)1, (int)catalog1.getDescriptors(String.class).size());
        Assertions.assertTrue((boolean)catalog1.hasDescriptor(RULE1, String.class));
        Assertions.assertTrue((boolean)catalog1.hasDescriptor(RULE2, String.class));
        Assertions.assertFalse((boolean)catalog1.hasDescriptor(RULE3, String.class));
        Assertions.assertTrue((boolean)catalog1.hasDomain("Domain"));
        Assertions.assertFalse((boolean)catalog1.hasDomain("domain"));
        Assertions.assertTrue((boolean)catalog1.hasRule(RULE1));
        Assertions.assertEquals(String.class, (Object)DESCRIPTOR12.getDataClass());
        Assertions.assertEquals((Object)FormalParams.NO_PARAMS, (Object)DESCRIPTOR12.getFormalParams());
        IssuesDetector detector1 = catalog1.createIssuesDetector(RULE1, String.class);
        Assertions.assertEquals(String.class, (Object)detector1.getDataClass());
        Assertions.assertSame(DESCRIPTOR12, (Object)detector1.getDescriptor());
        Assertions.assertEquals((int)1, (int)detector1.getEnabledRules().size());
        Assertions.assertTrue((boolean)detector1.getEnabledRules().contains(RULE1));
        Assertions.assertEquals((Object)Params.NO_PARAMS, (Object)detector1.getParams());
        Assertions.assertThrows(IllegalArgumentException.class, () -> RulesCatalogTest.lambda$test$0((RulesCatalog)catalog1));
        Assertions.assertEquals((int)1, (int)ccatalog.getDomains().size());
        Assertions.assertEquals((int)3, (int)ccatalog.getRules().size());
        Assertions.assertEquals((int)3, (int)ccatalog.getRules("Domain").size());
        Assertions.assertEquals((int)0, (int)ccatalog.getRules("domain").size());
        Assertions.assertEquals((int)1, (int)ccatalog.getDescriptors().size());
        Assertions.assertEquals((int)1, (int)ccatalog.getDescriptors(String.class).size());
        Assertions.assertTrue((boolean)ccatalog.hasDescriptor(RULE1, String.class));
        Assertions.assertTrue((boolean)ccatalog.hasDescriptor(RULE2, String.class));
        Assertions.assertFalse((boolean)ccatalog.hasDescriptor(RULE3, String.class));
        detector1.toString();
        IssuesDetector detector12 = catalog1.getDescriptor(RULE1, String.class).create(Params.NO_PARAMS, CollectionUtils.toSet((Object[])new Rule[]{RULE1, RULE2}));
        Assertions.assertEquals((int)2, (int)detector12.getEnabledRules().size());
        detector12.toString();
        Assertions.assertThrows(IllegalArgumentException.class, () -> DESCRIPTOR12.create(Params.NO_PARAMS, CollectionUtils.toSet((Object[])new Rule[]{RULE3})));
        IssuesCollector collector = new IssuesCollector();
        Assertions.assertSame((Object)IssuesHandler.VOID, (Object)collector.getDelegate());
        DefaultLocation location = new DefaultLocation("Test");
        detector1.analyze((Object)"Hello", (Location)location, (IssuesHandler)collector);
        Assertions.assertEquals((int)1, (int)collector.getIssues().size());
        Assertions.assertEquals((int)1, (int)collector.getIssues(IssueSeverity.INFO).size());
        collector.clear();
        ArrayList data = new ArrayList();
        Collections.addAll(data, new DefaultLocatedData((Object)"Hello", (Location)location), new DefaultLocatedData((Object)"World", (Location)location));
        catalog1.apply(String.class, Params.NO_PARAMS, data.spliterator(), (IssuesHandler)new VerboseIssuesHandler((IssuesHandler)collector), ProgressController.VERBOSE);
        Assertions.assertEquals((int)4, (int)collector.getIssues().size());
    }

    private static /* synthetic */ void lambda$test$0(RulesCatalog catalog1) throws Throwable {
        catalog1.createIssuesDetector(RULE3, String.class);
    }

    static class Detector1
    extends AbstractIssueDetector<String> {
        Detector1(Set<Rule> enabledRules) {
            super(DESCRIPTOR12, enabledRules);
        }

        public void analyze(String data, Location location, IssuesHandler<Issue> issuesHandler) {
            LOGGER.info("analyze({}, {})", (Object)data, (Object)location);
            for (Rule rule : this.getEnabledRules()) {
                issuesHandler.issue(Issue.builder().domain(rule.getDomain()).name(rule.getName()).description("Analyzed " + data).severity(IssueSeverity.INFO).addLocation(location).build());
            }
        }
    }
}

