/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FormalParams {
    public static final FormalParams NO_PARAMS = FormalParams.builder().build();
    private final Map<String, String> map = new HashMap<String, String>();

    private FormalParams(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<String> getNames() {
        return this.map.keySet();
    }

    public List<String> getSortedNames() {
        return this.map.keySet().stream().sorted().collect(Collectors.toList());
    }

    public String getDescription(String name) {
        return this.map.get(name);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FormalParams)) {
            return false;
        }
        FormalParams other = (FormalParams)object;
        return this.map.equals(other.map);
    }

    public String toString() {
        return this.getSortedNames().stream().map(name -> name + ":" + this.getDescription((String)name)).collect(Collectors.joining(" ", "[", "]"));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> map = new HashMap<String, String>();

        private Builder() {
        }

        public Builder param(String name, String description) {
            this.map.put(name, description);
            return this;
        }

        public FormalParams build() {
            return new FormalParams(this.map);
        }
    }
}

