/*
 * Decompiled with CFR 0.152.
 */
package cdc.issues.api;

import cdc.issues.api.Params;
import cdc.issues.api.locations.Location;
import cdc.issues.api.rules.RuleId;
import cdc.util.lang.Checks;
import java.util.Arrays;
import java.util.Objects;

public class IssueId {
    private final RuleId ruleId;
    private final Params params;
    private final Location[] locations;

    public IssueId(RuleId ruleId, Params params, Location ... locations) {
        this.ruleId = (RuleId)Checks.isNotNull((Object)ruleId, (String)"ruleId");
        this.params = (Params)Checks.isNotNull((Object)params, (String)"params");
        this.locations = (Location[])((Location[])Checks.isNotNull((Object)locations, (String)"locations")).clone();
        if (locations.length == 0) {
            throw new IllegalArgumentException("Empty locations");
        }
    }

    public IssueId(String domain, String name, Params params, Location ... locations) {
        this(new RuleId(domain, name), params, locations);
    }

    public IssueId(RuleId ruleId, Location ... locations) {
        this(ruleId, Params.NO_PARAMS, locations);
    }

    public IssueId(String domain, String name, Location ... locations) {
        this(domain, name, Params.NO_PARAMS, locations);
    }

    public IssueId(String domain, Enum<?> name, Params params, Location ... locations) {
        this(domain, name.name(), params, locations);
    }

    public IssueId(String domain, Enum<?> name, Location ... locations) {
        this(domain, name, Params.NO_PARAMS, locations);
    }

    public RuleId getRuleId() {
        return this.ruleId;
    }

    public String getDomain() {
        return this.ruleId.getDomain();
    }

    public String getName() {
        return this.ruleId.getName();
    }

    public <T extends Enum<T>> T getName(Class<T> cls) {
        return this.ruleId.getName(cls);
    }

    public Params getParams() {
        return this.params;
    }

    public Location[] getLocations() {
        return (Location[])this.locations.clone();
    }

    public int hashCode() {
        return Objects.hash(this.ruleId, this.params) + 31 * Arrays.hashCode(this.locations);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IssueId)) {
            return false;
        }
        IssueId other = (IssueId)object;
        return this.ruleId.equals(other.ruleId) && this.params.equals(other.params) && Arrays.equals(this.locations, other.locations);
    }

    public String toString() {
        return "[" + this.ruleId + " " + this.params + " " + Arrays.toString(this.locations) + "]";
    }
}

